# 🤖 نظام البوتات المتعددة - Telegram Bots System

**الإصدار:** 2.0  
**التاريخ:** 2025-10-25  
**الحالة:** ✅ نشط ومُحدّث

---

## 📋 نظرة عامة

نظام متكامل لإدارة بوتات Telegram متعددة مع نظام حدود ذكي وعزل كامل بين البوتات.

### المميزات الرئيسية:
- ✅ بوت مركزي للإدارة
- ✅ بوتات فرعية متعددة
- ✅ نظام حدود ذكي لكل بوت
- ✅ عزل كامل بين البوتات
- ✅ إدارة الحسابات والأكواد
- ✅ نظام مجموعات مرن

---

## 📁 هيكل المشروع

```
bott111/
├── 📄 control_bot.php           - البوت المركزي (الإدارة)
├── 📄 sub_bot.php                - البوت الفرعي (الخدمة)
├── 📄 .env.php                   - إعدادات قاعدة البيانات
├── 📄 cron_limits_maintenance.php - صيانة الحدود التلقائية
│
├── 📁 lib/                       - المكتبات الأساسية
│   ├── limits.php                - دوال الحدود
│   ├── limits_core.php           - منطق الحدود الأساسي
│   └── ...
│
├── 📁 src/                       - الوحدات
│   ├── ResponsesManager/         - إدارة الردود
│   ├── VoucherManager/           - إدارة الأكواد
│   └── ...
│
├── 📁 sql/                       - قواعد البيانات
│   └── new sql/
│       └── supehgku_test0 (1).sql - قاعدة البيانات النشطة
│
├── 📁 migration_system/          - نظام الترحيل والتحديثات
│   └── analysis/                 - تحليلات النظام
│
└── 📁 ARCHIVE/                   - الأرشيف
    └── 2025-10-25_bot_isolation_migration/
        ├── sql_updates/          - تحديثات SQL
        ├── documentation/        - التوثيق
        ├── reports/              - التقارير
        └── code/                 - الكود المؤرشف
```

---

## 🚀 البدء السريع

### 1. المتطلبات:
- PHP 7.4+
- MySQL/MariaDB
- Composer
- حساب Telegram Bot API

### 2. التثبيت:

```bash
# نسخ الملفات
# رفع على الاستضافة

# إعداد قاعدة البيانات
# استيراد: sql/new sql/supehgku_test0 (1).sql

# تكوين البيئة
# تحديث: .env.php
```

### 3. التشغيل:

```bash
# البوت المركزي
php control_bot.php

# البوت الفرعي
php sub_bot.php
```

---

## 🎯 المكونات الرئيسية

### 1. البوت المركزي (`control_bot.php`)
- إدارة البوتات الفرعية
- إدارة الحسابات
- إدارة الحدود
- إدارة المجموعات
- إحصائيات ومراقبة

### 2. البوت الفرعي (`sub_bot.php`)
- توزيع الأكواد
- تطبيق الحدود
- التفاعل مع المستخدمين
- الاتصال بالمجموعات

### 3. نظام الحدود (`lib/limits*.php`)
- حدود يومية/أسبوعية/شهرية
- حدود عامة/خاصة بالبوت/خاصة بالحساب
- نظام حظر ذكي
- عزل كامل بين البوتات

---

## 📊 قاعدة البيانات

### الجداول الرئيسية:

| الجدول | الوصف |
|--------|-------|
| `sub_bots` | البوتات الفرعية |
| `steam_accounts` | حسابات Steam |
| `groups` | المجموعات |
| `bot_groups` | ربط البوتات بالمجموعات |
| `limits_global` | الحدود العامة |
| `limits_bot` | حدود البوتات |
| `limits_override` | حدود خاصة بالحسابات |
| `limit_counters` | عدادات الاستخدام |
| `limit_bans` | سجل الحظر |

---

## 🎨 نظام الحدود

### الأولويات:
```
1. limits_override (حساب معين)
2. limits_bot (بوت معين)
3. limits_global (عام)
```

### الأوضاع:
- **daily:** حد يومي فقط
- **weekly:** حد يومي + حد أسبوعي
- **monthly:** حد يومي + حد شهري

### العزل:
- كل بوت له عداداته المستقلة
- كل بوت له حظره المستقل
- نفس المستخدم + نفس الحساب = عدادات منفصلة في بوتات مختلفة

---

## 📖 الوثائق

### الأدلة:
- [دليل نظام الحدود](migration_system/analysis/) - شرح مفصل
- [أوامر الحدود](ARCHIVE/2025-10-25_bot_isolation_migration/documentation/BOT_LIMITS_COMMANDS.md) - جميع الأوامر
- [دليل التكامل](ARCHIVE/2025-10-25_bot_isolation_migration/documentation/INTEGRATION_GUIDE.md) - كيفية التكامل

### التقارير:
- [تقرير قاعدة البيانات](ARCHIVE/2025-10-25_bot_isolation_migration/reports/DB_VERIFICATION_REPORT.md)
- [الملخص التنفيذي](ARCHIVE/2025-10-25_bot_isolation_migration/reports/EXECUTIVE_SUMMARY.md)

---

## 🔧 الصيانة

### Cron Jobs:

```bash
# تنظيف الحظر المنتهي (كل ساعة)
0 * * * * php /path/to/cron_limits_maintenance.php

# إعادة تعيين العدادات (يومي - منتصف الليل)
0 0 * * * php /path/to/cron_limits_maintenance.php
```

---

## 📦 التحديثات الأخيرة

### v2.0 (2025-10-25) - عزل البوتات
- ✅ إضافة `bot_label` إلى `limit_counters`
- ✅ إضافة `bot_label` إلى `limit_bans`
- ✅ عزل كامل بين البوتات
- ✅ تحديث دوال PHP
- ✅ تحديث المفاتيح والعلاقات

**للتفاصيل:** [ARCHIVE/2025-10-25_bot_isolation_migration/](ARCHIVE/2025-10-25_bot_isolation_migration/)

---

## 🐛 استكشاف الأخطاء

### مشاكل شائعة:

1. **"البوت لا يستجيب"**
   - تحقق من webhook
   - تحقق من قاعدة البيانات
   - تحقق من السجلات

2. **"الحدود لا تعمل"**
   - تحقق من `limits_bot`
   - تحقق من `bot_label` في الجداول
   - تحقق من ملفات PHP المحدثة

3. **"الأكواد لا تُرسل"**
   - تحقق من الحسابات النشطة
   - تحقق من المجموعات المرتبطة
   - تحقق من الحدود

---

## 📞 الدعم

للمساعدة أو الإبلاغ عن مشاكل:
- راجع الوثائق في [ARCHIVE](ARCHIVE/)
- راجع التقارير في [migration_system/analysis](migration_system/analysis/)

---

## 📝 الترخيص

هذا المشروع للاستخدام الخاص.

---

## 🙏 ملاحظات

- تم تطوير النظام بشكل تدريجي
- جميع التحديثات موثّقة
- الأرشيف يحتوي على تاريخ كامل للتطوير

---

*آخر تحديث: 2025-10-25*
