-- ================================================================
-- الحل الكامل: عزل الحدود والحظر لكل بوت
-- ================================================================
-- المشكلة: العدادات والحظر مشتركة بين جميع البوتات
-- الحل: إضافة bot_label إلى limit_counters و limit_bans
-- ================================================================
-- النتيجة: كل بوت له عداداته وحظره المستقل
-- ================================================================

START TRANSACTION;

-- ═══════════════════════════════════════════════════════════════
-- الجزء 1: تعديل limit_counters
-- ═══════════════════════════════════════════════════════════════

-- 1.1 حذف المفتاح الفريد القديم
ALTER TABLE `limit_counters` 
DROP INDEX IF EXISTS `unique_user_account`;

-- 1.2 إضافة عمود bot_label
ALTER TABLE `limit_counters` 
ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

-- 1.3 إضافة index لـ bot_label
ALTER TABLE `limit_counters`
ADD INDEX `idx_bot_counters` (`bot_label`);

-- 1.4 ملء bot_label للسجلات الموجودة
-- الخيار أ: تعيين الكل إلى test1 (الافتراضي)
UPDATE `limit_counters` 
SET `bot_label` = 'test1' 
WHERE `bot_label` IS NULL;

-- الخيار ب: إذا كنت تريد حذف السجلات القديمة بدلاً من ذلك
-- DELETE FROM `limit_counters` WHERE `bot_label` IS NULL;

-- 1.5 جعل bot_label إجباري
ALTER TABLE `limit_counters` 
MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- 1.6 إضافة مفتاح فريد جديد (user_id, account_id, bot_label)
ALTER TABLE `limit_counters` 
ADD UNIQUE KEY `unique_user_account_bot` (`user_id`, `account_id`, `bot_label`);

-- 1.7 إضافة foreign key لـ bot_label
ALTER TABLE `limit_counters`
ADD CONSTRAINT `fk_counters_bot_label` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

-- ═══════════════════════════════════════════════════════════════
-- الجزء 2: تعديل limit_bans
-- ═══════════════════════════════════════════════════════════════

-- 2.1 حذف المفتاح الفريد القديم (إذا وُجد)
ALTER TABLE `limit_bans` 
DROP INDEX IF EXISTS `unique_user_account_ban`;

-- 2.2 إضافة عمود bot_label
ALTER TABLE `limit_bans` 
ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

-- 2.3 إضافة index لـ bot_label
ALTER TABLE `limit_bans`
ADD INDEX `idx_bot_bans` (`bot_label`);

-- 2.4 ملء bot_label للسجلات الموجودة
UPDATE `limit_bans` 
SET `bot_label` = 'test1' 
WHERE `bot_label` IS NULL;

-- 2.5 جعل bot_label إجباري
ALTER TABLE `limit_bans` 
MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- 2.6 إضافة مفتاح فريد جديد (user_id, account_id, bot_label)
ALTER TABLE `limit_bans` 
ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`, `account_id`, `bot_label`);

-- 2.7 إضافة foreign key لـ bot_label
ALTER TABLE `limit_bans`
ADD CONSTRAINT `fk_bans_bot_label` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

COMMIT;

-- ═══════════════════════════════════════════════════════════════
-- الجزء 3: التحقق من النتائج (اختياري)
-- ═══════════════════════════════════════════════════════════════
-- نفّذ هذه الأوامر بشكل منفصل بعد COMMIT

-- 3.1 عرض بنية limit_counters
-- SELECT 
--     COLUMN_NAME as 'اسم العمود',
--     COLUMN_TYPE as 'النوع',
--     IS_NULLABLE as 'قابل للفراغ',
--     COLUMN_KEY as 'المفتاح',
--     COLUMN_DEFAULT as 'القيمة الافتراضية',
--     COLUMN_COMMENT as 'التعليق'
-- FROM INFORMATION_SCHEMA.COLUMNS
-- WHERE TABLE_SCHEMA = DATABASE()
--   AND TABLE_NAME = 'limit_counters'
-- ORDER BY ORDINAL_POSITION;

-- 3.2 عرض مفاتيح limit_counters
-- SHOW INDEX FROM `limit_counters`;

-- 3.3 عرض بنية limit_bans
-- SELECT 
--     COLUMN_NAME as 'اسم العمود',
--     COLUMN_TYPE as 'النوع',
--     IS_NULLABLE as 'قابل للفراغ',
--     COLUMN_KEY as 'المفتاح',
--     COLUMN_COMMENT as 'التعليق'
-- FROM INFORMATION_SCHEMA.COLUMNS
-- WHERE TABLE_SCHEMA = DATABASE()
--   AND TABLE_NAME = 'limit_bans'
-- ORDER BY ORDINAL_POSITION;

-- 3.4 عرض مفاتيح limit_bans
-- SHOW INDEX FROM `limit_bans`;

-- 3.5 عرض البيانات الحالية في limit_counters
-- SELECT * FROM `limit_counters`;

-- 3.6 عرض البيانات الحالية في limit_bans
-- SELECT * FROM `limit_bans`;

-- ================================================================
-- ✅ تم التطبيق بنجاح!
-- ================================================================
-- الآن:
-- • كل بوت له عداداته المستقلة
-- • كل بوت له حظره المستقل
-- • المستخدم نفسه + الحساب نفسه في بوتات مختلفة = عدادات منفصلة
-- 
-- مثال:
-- test1 → user 123 + account 456 → day_used=5
-- test2 → user 123 + account 456 → day_used=0 (مستقل!)
-- ================================================================

-- ملاحظة مهمة:
-- بعد تطبيق هذا SQL، يجب رفع الملفات المحدثة:
-- • lib/limits.php (محدث ✅)
-- • lib/limits_core.php (محدث ✅)
-- ================================================================
