-- ================================================================
-- النسخة الآمنة: عزل الحدود لكل بوت
-- ================================================================
-- تتعامل مع الحالات التالية:
-- • العمود موجود مسبقاً
-- • المفتاح موجود مسبقاً
-- • التنفيذ الجزئي السابق
-- ================================================================

-- ═══════════════════════════════════════════════════════════════
-- خطوة 1: التحقق من الحالة الحالية
-- ═══════════════════════════════════════════════════════════════

-- عرض الأعمدة الحالية في limit_counters
SELECT COLUMN_NAME 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_counters'
ORDER BY ORDINAL_POSITION;

-- عرض المفاتيح الحالية
SELECT DISTINCT INDEX_NAME 
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_counters';

-- ═══════════════════════════════════════════════════════════════
-- خطوة 2: التطبيق اليدوي
-- ═══════════════════════════════════════════════════════════════
-- بناءً على النتيجة أعلاه، نفّذ فقط الأوامر المطلوبة:

-- ────────────────────────────────────────────────────────────────
-- A. إذا لم يكن bot_label موجوداً في limit_counters
-- ────────────────────────────────────────────────────────────────

-- ALTER TABLE `limit_counters` 
-- ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

-- ALTER TABLE `limit_counters` 
-- ADD INDEX `idx_bot_counters` (`bot_label`);

-- ────────────────────────────────────────────────────────────────
-- B. إذا كان bot_label موجوداً لكن فارغ (NULL)
-- ────────────────────────────────────────────────────────────────

-- UPDATE `limit_counters` 
-- SET `bot_label` = 'test1' 
-- WHERE `bot_label` IS NULL;

-- ────────────────────────────────────────────────────────────────
-- C. إذا كان bot_label موجوداً لكن يقبل NULL
-- ────────────────────────────────────────────────────────────────

-- ALTER TABLE `limit_counters` 
-- MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- ────────────────────────────────────────────────────────────────
-- D. حذف المفتاح القديم (إذا وُجد)
-- ────────────────────────────────────────────────────────────────

-- ALTER TABLE `limit_counters` 
-- DROP INDEX IF EXISTS `unique_user_account`;

-- ────────────────────────────────────────────────────────────────
-- E. إضافة المفتاح الجديد (إذا لم يكن موجوداً)
-- ────────────────────────────────────────────────────────────────

-- ALTER TABLE `limit_counters` 
-- ADD UNIQUE KEY `unique_user_account_bot` (`user_id`, `account_id`, `bot_label`);

-- ────────────────────────────────────────────────────────────────
-- F. إضافة foreign key (إذا لم يكن موجوداً)
-- ────────────────────────────────────────────────────────────────

-- ALTER TABLE `limit_counters`
-- ADD CONSTRAINT `fk_counters_bot_label` 
-- FOREIGN KEY (`bot_label`) 
-- REFERENCES `sub_bots`(`label`) 
-- ON UPDATE CASCADE 
-- ON DELETE CASCADE;

-- ═══════════════════════════════════════════════════════════════
-- خطوة 3: نفس الشيء لـ limit_bans
-- ═══════════════════════════════════════════════════════════════

-- عرض الأعمدة الحالية في limit_bans
SELECT COLUMN_NAME 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_bans'
ORDER BY ORDINAL_POSITION;

-- A. إضافة bot_label إذا لم يكن موجوداً
-- ALTER TABLE `limit_bans` 
-- ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

-- ALTER TABLE `limit_bans` 
-- ADD INDEX `idx_bot_bans` (`bot_label`);

-- B. ملء القيم الفارغة
-- UPDATE `limit_bans` 
-- SET `bot_label` = 'test1' 
-- WHERE `bot_label` IS NULL;

-- C. جعله إجباري
-- ALTER TABLE `limit_bans` 
-- MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- D. حذف المفتاح القديم
-- ALTER TABLE `limit_bans` 
-- DROP INDEX IF EXISTS `unique_user_account_ban`;

-- E. إضافة المفتاح الجديد
-- ALTER TABLE `limit_bans` 
-- ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`, `account_id`, `bot_label`);

-- F. إضافة foreign key
-- ALTER TABLE `limit_bans`
-- ADD CONSTRAINT `fk_bans_bot_label` 
-- FOREIGN KEY (`bot_label`) 
-- REFERENCES `sub_bots`(`label`) 
-- ON UPDATE CASCADE 
-- ON DELETE CASCADE;

-- ================================================================
-- ✅ دليل الاستخدام
-- ================================================================
-- 1. نفّذ خطوة 1 و 3 أولاً (SELECT)
-- 2. بناءً على النتيجة، أزل -- من الأوامر المطلوبة فقط
-- 3. نفّذ الأوامر المحددة
-- ================================================================
