<?php
/**
 * ملف تشخيص الأوامر
 * 
 * ضع هذا الملف في نفس مجلد control_bot.php
 * واستدعيه من المتصفح: https://yourdomain.com/DEBUG_COMMANDS.php
 * 
 * سيعرض لك:
 * - هل قاعدة البيانات متصلة؟
 * - هل الجداول موجودة؟
 * - هل البيانات موجودة؟
 * - ما هي المشكلة بالضبط؟
 */

require __DIR__ . '/lib/telegram.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تشخيص الأوامر</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; border-bottom: 3px solid #4CAF50; padding-bottom: 10px; }
        h2 { color: #555; margin-top: 30px; }
        .success { color: #4CAF50; font-weight: bold; }
        .error { color: #f44336; font-weight: bold; }
        .warning { color: #ff9800; font-weight: bold; }
        .info { background: #e3f2fd; padding: 15px; border-left: 4px solid #2196F3; margin: 10px 0; }
        .code { background: #f5f5f5; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { padding: 10px; text-align: right; border-bottom: 1px solid #ddd; }
        th { background: #4CAF50; color: white; }
        .test-item { margin: 15px 0; padding: 15px; border-radius: 5px; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 تشخيص أوامر البوت</h1>
        <p>التاريخ: <?= date('Y-m-d H:i:s') ?></p>

        <?php
        $tests = [];
        $db = null;

        // ==========================================
        // اختبار 1: الاتصال بقاعدة البيانات
        // ==========================================
        echo "<div class='test-item'>";
        echo "<h2>1️⃣ اختبار الاتصال بقاعدة البيانات</h2>";
        
        try {
            $db = pdo();
            echo "<p class='success'>✅ الاتصال ناجح!</p>";
            $tests['db_connection'] = true;
        } catch (Exception $e) {
            echo "<p class='error'>❌ فشل الاتصال!</p>";
            echo "<div class='code'>" . htmlspecialchars($e->getMessage()) . "</div>";
            echo "<div class='info'><strong>الحل:</strong> تحقق من ملف .env أو config.php</div>";
            $tests['db_connection'] = false;
            echo "</div>";
            echo "</div></body></html>";
            exit;
        }
        echo "</div>";

        // ==========================================
        // اختبار 2: جدول message_templates
        // ==========================================
        echo "<div class='test-item'>";
        echo "<h2>2️⃣ جدول message_templates</h2>";
        
        try {
            $count = $db->query("SELECT COUNT(*) as c FROM message_templates")->fetch()['c'];
            echo "<p class='success'>✅ الجدول موجود!</p>";
            echo "<p>📊 عدد الردود: <strong>{$count}</strong></p>";
            $tests['message_templates'] = true;
            
            if ($count == 0) {
                echo "<p class='warning'>⚠️ الجدول فارغ!</p>";
                echo "<div class='info'><strong>السبب:</strong> لم يتم تطبيق SQL أو تم حذف البيانات</div>";
                $tests['message_templates_data'] = false;
            } else {
                $tests['message_templates_data'] = true;
                
                // عرض البيانات
                echo "<h3>📋 الردود الموجودة:</h3>";
                $rows = $db->query("SELECT `key`, LEFT(text, 50) as preview FROM message_templates ORDER BY `key`")->fetchAll();
                echo "<table>";
                echo "<tr><th>المفتاح</th><th>معاينة</th></tr>";
                foreach ($rows as $r) {
                    echo "<tr><td>" . htmlspecialchars($r['key']) . "</td><td>" . htmlspecialchars($r['preview']) . "...</td></tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ الجدول غير موجود أو خطأ في SQL!</p>";
            echo "<div class='code'>" . htmlspecialchars($e->getMessage()) . "</div>";
            echo "<div class='info'><strong>الحل:</strong><br>mysql -u user -p database &lt; sql/supehgku_test0.sql</div>";
            $tests['message_templates'] = false;
        }
        echo "</div>";

        // ==========================================
        // اختبار 3: جدول limit_messages
        // ==========================================
        echo "<div class='test-item'>";
        echo "<h2>3️⃣ جدول limit_messages</h2>";
        
        try {
            $count = $db->query("SELECT COUNT(*) as c FROM limit_messages")->fetch()['c'];
            echo "<p class='success'>✅ الجدول موجود!</p>";
            echo "<p>📊 عدد الرسائل: <strong>{$count}</strong></p>";
            $tests['limit_messages'] = true;
            
            if ($count == 0) {
                echo "<p class='warning'>⚠️ الجدول فارغ!</p>";
                $tests['limit_messages_data'] = false;
            } else {
                $tests['limit_messages_data'] = true;
                
                // عرض البيانات
                echo "<h3>📋 الرسائل الموجودة:</h3>";
                $rows = $db->query("SELECT event, LEFT(text, 40) as preview FROM limit_messages ORDER BY event")->fetchAll();
                echo "<table>";
                echo "<tr><th>الحدث</th><th>معاينة</th></tr>";
                foreach ($rows as $r) {
                    echo "<tr><td>" . htmlspecialchars($r['event']) . "</td><td>" . htmlspecialchars($r['preview']) . "...</td></tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ الجدول غير موجود أو خطأ في SQL!</p>";
            echo "<div class='code'>" . htmlspecialchars($e->getMessage()) . "</div>";
            $tests['limit_messages'] = false;
        }
        echo "</div>";

        // ==========================================
        // اختبار 4: جدول bot_message_templates
        // ==========================================
        echo "<div class='test-item'>";
        echo "<h2>4️⃣ جدول bot_message_templates</h2>";
        
        try {
            $count = $db->query("SELECT COUNT(*) as c FROM bot_message_templates")->fetch()['c'];
            echo "<p class='success'>✅ الجدول موجود!</p>";
            echo "<p>📊 عدد الردود المخصصة: <strong>{$count}</strong></p>";
            $tests['bot_message_templates'] = true;
            
            if ($count > 0) {
                $rows = $db->query("SELECT bmt.*, sb.label FROM bot_message_templates bmt LEFT JOIN sub_bots sb ON bmt.bot_id = sb.id LIMIT 5")->fetchAll();
                echo "<table>";
                echo "<tr><th>البوت</th><th>المفتاح</th><th>معاينة</th></tr>";
                foreach ($rows as $r) {
                    $preview = mb_substr($r['template_text'], 0, 30);
                    echo "<tr><td>" . htmlspecialchars($r['label'] ?? 'N/A') . "</td><td>" . htmlspecialchars($r['template_key']) . "</td><td>" . htmlspecialchars($preview) . "...</td></tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ الجدول غير موجود أو خطأ في SQL!</p>";
            echo "<div class='code'>" . htmlspecialchars($e->getMessage()) . "</div>";
            $tests['bot_message_templates'] = false;
        }
        echo "</div>";

        // ==========================================
        // التقرير النهائي
        // ==========================================
        echo "<div class='test-item' style='background: #f9f9f9;'>";
        echo "<h2>📊 التقرير النهائي</h2>";
        
        $passed = count(array_filter($tests));
        $total = count($tests);
        
        echo "<p><strong>الاختبارات الناجحة:</strong> {$passed} / {$total}</p>";
        
        if ($passed == $total) {
            echo "<p class='success' style='font-size: 18px;'>🎉 كل شيء يعمل بشكل صحيح!</p>";
            echo "<div class='info'>";
            echo "<strong>إذا كانت الأوامر لا تزال لا تعمل في البوت:</strong><br>";
            echo "1. تأكد من رفع control_bot.php المُحدّث<br>";
            echo "2. تأكد من أن الـ webhook مُعدّ بشكل صحيح<br>";
            echo "3. تحقق من الـ logs على السيرفر<br>";
            echo "4. جرّب إرسال /start ثم /responses";
            echo "</div>";
        } else {
            echo "<p class='error' style='font-size: 18px;'>❌ هناك مشاكل تحتاج إلى إصلاح!</p>";
            echo "<div class='info'>";
            echo "<strong>الخطوات التالية:</strong><br>";
            echo "<div class='code'>mysql -u username -p database_name &lt; sql/supehgku_test0.sql</div>";
            echo "ثم أعد تحميل هذه الصفحة للتحقق مرة أخرى.";
            echo "</div>";
        }
        
        echo "</div>";
        ?>

        <div style="margin-top: 30px; padding: 20px; background: #e8f5e9; border-radius: 5px;">
            <h3>💡 نصائح إضافية:</h3>
            <ul>
                <li>إذا كانت الجداول موجودة والبيانات موجودة، المشكلة في control_bot.php أو webhook</li>
                <li>تأكد من رفع آخر نسخة من control_bot.php (مع معالجة الأخطاء)</li>
                <li>تحقق من error logs في السيرفر</li>
                <li>جرّب الأوامر مرة أخرى في البوت</li>
            </ul>
        </div>
    </div>
</body>
</html>
