<?php
/**
 * ملف معلومات السيرفر - للتحقق من الإعدادات
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>معلومات PHP</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "PDO: " . (extension_loaded('pdo') ? '✅ مفعّل' : '❌ غير مفعّل') . "<br>";
echo "PDO MySQL: " . (extension_loaded('pdo_mysql') ? '✅ مفعّل' : '❌ غير مفعّل') . "<br>";

echo "<h2>المجلد الحالي</h2>";
echo "Directory: " . __DIR__ . "<br>";
echo "Files in directory:<br>";
$files = scandir(__DIR__);
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        echo "- $file<br>";
    }
}

echo "<h2>اختبار ملفات الإعداد</h2>";
if (file_exists(__DIR__ . '/config_source.php')) {
    echo "✅ config_source.php موجود<br>";
    try {
        $config = require __DIR__ . '/config_source.php';
        echo "Database: " . $config['DB_NAME'] . "<br>";
    } catch (Exception $e) {
        echo "❌ خطأ: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ config_source.php غير موجود<br>";
}

if (file_exists(__DIR__ . '/config_target.php')) {
    echo "✅ config_target.php موجود<br>";
    try {
        $config = require __DIR__ . '/config_target.php';
        echo "Database: " . $config['DB_NAME'] . "<br>";
    } catch (Exception $e) {
        echo "❌ خطأ: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ config_target.php غير موجود<br>";
}

phpinfo();
