<?php
/**
 * نسخة Web من سكريبت الترحيل - النسخة المصححة
 * تعمل من المتصفح - إصلاح مشكلة LIMIT
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(600); // 10 دقائق

// ========================================
// التحقق من ملفات الإعداد
// ========================================

if (!file_exists(__DIR__ . '/config_source.php')) {
    die("<h1>❌ ERROR</h1><p>ملف config_source.php غير موجود</p>");
}
if (!file_exists(__DIR__ . '/config_target.php')) {
    die("<h1>❌ ERROR</h1><p>ملف config_target.php غير موجود</p>");
}

$sourceConfig = require __DIR__ . '/config_source.php';
$targetConfig = require __DIR__ . '/config_target.php';

// ========================================
// HTML Header
// ========================================
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ترحيل البيانات - المصحح</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 30px;
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
        }
        .info-box {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
        .success {
            background: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            border-left-color: #dc3545;
            color: #721c24;
        }
        .warning {
            background: #fff3cd;
            border-left-color: #ffc107;
            color: #856404;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s;
        }
        .btn:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        .btn-danger {
            background: #dc3545;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .log {
            background: #1e1e1e;
            color: #00ff00;
            padding: 20px;
            border-radius: 10px;
            font-family: 'Courier New', monospace;
            max-height: 400px;
            overflow-y: auto;
            margin-top: 20px;
            font-size: 13px;
            line-height: 1.6;
        }
        .stat {
            display: flex;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        .stat:last-child {
            border-bottom: none;
        }
        .progress-text {
            color: #00ff00;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 ترحيل البيانات - النسخة المصححة</h1>

<?php
if (!isset($_POST['action'])) {
    // عرض الصفحة الرئيسية
    ?>
    <div class="info-box">
        <h3>📊 معلومات قواعد البيانات</h3>
        <div class="stat">
            <strong>قاعدة المصدر:</strong>
            <span><?php echo htmlspecialchars($sourceConfig['DB_NAME']); ?></span>
        </div>
        <div class="stat">
            <strong>قاعدة الهدف:</strong>
            <span><?php echo htmlspecialchars($targetConfig['DB_NAME']); ?></span>
        </div>
    </div>

    <div class="info-box warning">
        <h3>⚠️ تحذير مهم</h3>
        <p><strong>قبل البدء:</strong></p>
        <ul>
            <li>تأكد من أخذ نسخة احتياطية من قاعدة <?php echo htmlspecialchars($targetConfig['DB_NAME']); ?></li>
            <li>تأكد من عدم استخدام النظام حالياً</li>
            <li>العملية قد تستغرق 1-2 دقيقة</li>
        </ul>
    </div>

    <div class="info-box">
        <h3>✅ ما سيُرحّل:</h3>
        <ul>
            <li><strong>sub_bots</strong> - مع max_users (الحد الأقصى للمستخدمين)</li>
            <li><strong>steam_accounts</strong> - حسابات Steam</li>
            <li><strong>allowed_users</strong> - المستخدمين المصرح لهم</li>
            <li><strong>steam_requests</strong> - سجل الطلبات التاريخي</li>
        </ul>
    </div>

    <form method="POST" onsubmit="return confirm('هل أنت متأكد من بدء الترحيل؟');">
        <input type="hidden" name="action" value="test">
        <button type="submit" class="btn">🧪 اختبار الاتصال أولاً</button>
    </form>

    <?php
} elseif ($_POST['action'] === 'test') {
    // اختبار الاتصال
    echo '<div class="info-box"><h3>🔍 اختبار الاتصال...</h3></div>';
    
    try {
        // اختبار المصدر
        $dsn = "mysql:host={$sourceConfig['DB_HOST']};dbname={$sourceConfig['DB_NAME']};charset=utf8mb4";
        $sourceDB = new PDO($dsn, $sourceConfig['DB_USER'], $sourceConfig['DB_PASS'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        echo '<div class="info-box success">';
        echo '<strong>✅ اتصال ناجح بقاعدة المصدر</strong><br>';
        
        $stmt = $sourceDB->query("SELECT COUNT(*) as cnt FROM sub_bots");
        $count = $stmt->fetch()['cnt'];
        echo "عدد البوتات: $count<br>";
        
        $stmt = $sourceDB->query("SELECT COUNT(*) as cnt FROM steam_accounts");
        $count = $stmt->fetch()['cnt'];
        echo "عدد الحسابات: $count<br>";
        
        $stmt = $sourceDB->query("SELECT COUNT(*) as cnt FROM allowed_users");
        $count = $stmt->fetch()['cnt'];
        echo "عدد المستخدمين: $count<br>";
        
        $stmt = $sourceDB->query("SELECT COUNT(*) as cnt FROM steam_requests");
        $count = $stmt->fetch()['cnt'];
        echo "عدد الطلبات: $count<br>";
        
        echo '</div>';
        
        // اختبار الهدف
        $dsn = "mysql:host={$targetConfig['DB_HOST']};dbname={$targetConfig['DB_NAME']};charset=utf8mb4";
        $targetDB = new PDO($dsn, $targetConfig['DB_USER'], $targetConfig['DB_PASS'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        echo '<div class="info-box success">';
        echo '<strong>✅ اتصال ناجح بقاعدة الهدف</strong><br>';
        echo 'جميع الجداول موجودة وجاهزة';
        echo '</div>';
        
        echo '<form method="POST">';
        echo '<input type="hidden" name="action" value="migrate">';
        echo '<button type="submit" class="btn btn-danger">🚀 بدء الترحيل الفعلي</button>';
        echo '</form>';
        
    } catch (PDOException $e) {
        echo '<div class="info-box error">';
        echo '<strong>❌ خطأ في الاتصال</strong><br>';
        echo htmlspecialchars($e->getMessage());
        echo '</div>';
    }
    
} elseif ($_POST['action'] === 'migrate') {
    // الترحيل الفعلي
    echo '<div class="info-box"><h3>🚀 بدء الترحيل...</h3></div>';
    echo '<div class="log">';
    
    // تفعيل flush مباشر
    if (ob_get_level() > 0) {
        ob_end_flush();
    }
    ob_implicit_flush(true);
    
    try {
        // الاتصال
        $dsn = "mysql:host={$sourceConfig['DB_HOST']};dbname={$sourceConfig['DB_NAME']};charset=utf8mb4";
        $sourceDB = new PDO($dsn, $sourceConfig['DB_USER'], $sourceConfig['DB_PASS'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        $dsn = "mysql:host={$targetConfig['DB_HOST']};dbname={$targetConfig['DB_NAME']};charset=utf8mb4";
        $targetDB = new PDO($dsn, $targetConfig['DB_USER'], $targetConfig['DB_PASS'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        echo "[" . date('H:i:s') . "] ✅ اتصال ناجح بكلا القاعدتين<br>\n";
        flush();
        
        // تعطيل FK checks
        $targetDB->exec("SET FOREIGN_KEY_CHECKS=0");
        echo "[" . date('H:i:s') . "] تعطيل Foreign Key checks<br>\n";
        flush();
        
        // ترحيل sub_bots
        echo "<br>[" . date('H:i:s') . "] === ترحيل sub_bots ===<br>\n";
        flush();
        
        $stmt = $sourceDB->query("
            SELECT id, label, bot_token, channel_id, max_users, 
                   welcome_message, is_paused, created_at, updated_at
            FROM sub_bots
        ");
        
        $insertStmt = $targetDB->prepare("
            INSERT INTO sub_bots 
            (id, label, bot_token, channel_id, max_users, welcome_message, is_paused, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                label = VALUES(label),
                bot_token = VALUES(bot_token),
                channel_id = VALUES(channel_id),
                max_users = VALUES(max_users),
                welcome_message = VALUES(welcome_message),
                is_paused = VALUES(is_paused),
                updated_at = VALUES(updated_at)
        ");
        
        $count = 0;
        while ($row = $stmt->fetch()) {
            $insertStmt->execute([
                $row['id'], $row['label'], $row['bot_token'], $row['channel_id'],
                $row['max_users'], $row['welcome_message'], $row['is_paused'],
                $row['created_at'], $row['updated_at']
            ]);
            $count++;
        }
        
        echo "[" . date('H:i:s') . "] ✅ تم ترحيل $count بوت<br>\n";
        flush();
        
        // ترحيل steam_accounts
        echo "<br>[" . date('H:i:s') . "] === ترحيل steam_accounts ===<br>\n";
        flush();
        
        $stmt = $sourceDB->query("
            SELECT id, account_name, shared_secret, active, created_at, updated_at
            FROM steam_accounts
        ");
        
        $insertStmt = $targetDB->prepare("
            INSERT INTO steam_accounts 
            (id, account_name, shared_secret, active, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                account_name = VALUES(account_name),
                shared_secret = VALUES(shared_secret),
                active = VALUES(active),
                updated_at = VALUES(updated_at)
        ");
        
        $count = 0;
        while ($row = $stmt->fetch()) {
            $insertStmt->execute([
                $row['id'], $row['account_name'], $row['shared_secret'],
                $row['active'], $row['created_at'], $row['updated_at']
            ]);
            $count++;
        }
        
        echo "[" . date('H:i:s') . "] ✅ تم ترحيل $count حساب<br>\n";
        flush();
        
        // ترحيل allowed_users
        echo "<br>[" . date('H:i:s') . "] === ترحيل allowed_users ===<br>\n";
        flush();
        
        $stmt = $sourceDB->query("
            SELECT id, bot_token, user_id, banned, created_at
            FROM allowed_users
        ");
        
        $insertStmt = $targetDB->prepare("
            INSERT INTO allowed_users 
            (id, bot_token, user_id, banned, created_at)
            VALUES (?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                banned = VALUES(banned),
                created_at = VALUES(created_at)
        ");
        
        $count = 0;
        while ($row = $stmt->fetch()) {
            $insertStmt->execute([
                $row['id'], $row['bot_token'], $row['user_id'],
                $row['banned'], $row['created_at']
            ]);
            $count++;
        }
        
        echo "[" . date('H:i:s') . "] ✅ تم ترحيل $count مستخدم<br>\n";
        flush();
        
        // ترحيل steam_requests (دفعات) - مع إصلاح LIMIT
        echo "<br>[" . date('H:i:s') . "] === ترحيل steam_requests (قد يستغرق وقتاً) ===<br>\n";
        flush();
        
        $totalCount = $sourceDB->query("SELECT COUNT(*) as cnt FROM steam_requests")->fetch()['cnt'];
        $batchSize = 1000; // حجم الدفعة
        $lastId = 0;
        $totalMigrated = 0;
        
        $insertStmt = $targetDB->prepare("
            INSERT INTO steam_requests 
            (id, bot_token, user_id, account_name, request_time)
            VALUES (?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                bot_token = VALUES(bot_token),
                user_id = VALUES(user_id),
                account_name = VALUES(account_name),
                request_time = VALUES(request_time)
        ");
        
        while (true) {
            // ✅ إصلاح: استخدام LIMIT مباشرة بدلاً من placeholder
            $stmt = $sourceDB->prepare("
                SELECT id, bot_token, user_id, account_name, request_time
                FROM steam_requests
                WHERE id > :lastId
                ORDER BY id ASC
                LIMIT $batchSize
            ");
            $stmt->execute(['lastId' => $lastId]);
            $rows = $stmt->fetchAll();
            
            if (empty($rows)) {
                break;
            }
            
            foreach ($rows as $row) {
                $insertStmt->execute([
                    $row['id'], $row['bot_token'], $row['user_id'],
                    $row['account_name'], $row['request_time']
                ]);
                $lastId = $row['id'];
                $totalMigrated++;
            }
            
            $percent = round(($totalMigrated / $totalCount) * 100);
            echo "<span class='progress-text'>[" . date('H:i:s') . "] تقدم: $totalMigrated / $totalCount ($percent%)</span><br>\n";
            flush();
        }
        
        echo "[" . date('H:i:s') . "] ✅ تم ترحيل $totalMigrated طلب<br>\n";
        flush();
        
        // إعادة تفعيل FK checks
        $targetDB->exec("SET FOREIGN_KEY_CHECKS=1");
        echo "<br>[" . date('H:i:s') . "] إعادة تفعيل Foreign Key checks<br>\n";
        flush();
        
        echo "</div>";
        
        echo '<div class="info-box success">';
        echo '<h3>✅✅✅ الترحيل اكتمل بنجاح!</h3>';
        echo '<p><strong>الخطوات التالية:</strong></p>';
        echo '<ol>';
        echo '<li>ضبط نظام الحدود:<br><code>UPDATE limits_global SET mode=\'weekly\', per_day=2, weekly_cap=6, ban_days=7 WHERE id=1;</code></li>';
        echo '<li>اختبار بوت واحد</li>';
        echo '<li>مراقبة system_logs</li>';
        echo '</ol>';
        echo '<p><strong>✅ max_users (الحد الأقصى للمستخدمين) تم ترحيله مع كل بوت!</strong></p>';
        echo '</div>';
        
    } catch (PDOException $e) {
        echo "</div>";
        echo '<div class="info-box error">';
        echo '<strong>❌ خطأ أثناء الترحيل</strong><br>';
        echo htmlspecialchars($e->getMessage());
        echo '<br><br><strong>التفاصيل التقنية:</strong><br>';
        echo '<pre style="background:#000;color:#0f0;padding:10px;border-radius:5px;">';
        echo htmlspecialchars($e->getTraceAsString());
        echo '</pre>';
        echo '</div>';
    }
}
?>

    </div>
</body>
</html>
