# 🎯 أوامر نظام حدود البوتات - Bot Limits Commands

**النسخة:** 2.0  
**التاريخ:** 2025-10-25

---

## 📊 نظرة عامة

النظام يدعم **3 مستويات** من الحدود بأولويات:

```
1️⃣ limits_override  (حساب محدد)      ← أعلى أولوية
2️⃣ limits_bot       (بوت محدد)       ← أولوية متوسطة  
3️⃣ limits_global    (عام لجميع البوتات) ← أقل أولوية
```

---

## 🆕 الأوامر الجديدة لحدود البوتات

### `/limit_mode <bot_label> <mode>`
تغيير وضع الحدود لبوت محدد

**الاستخدام:**
```
/limit_mode vipbot weekly
/limit_mode testbot daily
/limit_mode premiumbot monthly
```

**الأوضاع:**
- `daily` - يومي (رفض فوري بعد الحد)
- `weekly` - أسبوعي (حد يومي + سقف أسبوعي + حظر)
- `monthly` - شهري (حد يومي + سقف شهري + حظر)

---

### `/set_daily <bot_label> <per_day>`
تعيين حد يومي بسيط لبوت

**الاستخدام:**
```
/set_daily testbot 3
→ 3 أكواد يومياً، رفض فوري بعدها
```

---

### `/set_weekly <bot_label> <per_day> <weekly_cap> <ban_days>`
تعيين حد أسبوعي متقدم لبوت

**الاستخدام:**
```
/set_weekly vipbot 5 20 3
→ 5 كود/يوم
→ بحد أقصى 20 كود/أسبوع
→ حظر 3 أيام عند التجاوز
```

---

### `/set_monthly <bot_label> <per_day> <monthly_cap> <ban_days>`
تعيين حد شهري متقدم لبوت

**الاستخدام:**
```
/set_monthly premiumbot 10 100 7
→ 10 كود/يوم
→ بحد أقصى 100 كود/شهر
→ حظر 7 أيام عند التجاوز
```

---

### `/bot_limit_clear <bot_label>`
حذف الحدود الخاصة ببوت (العودة للحدود العامة)

**الاستخدام:**
```
/bot_limit_clear testbot
→ سيستخدم testbot الحدود العامة مرة أخرى
```

---

## 🔍 أمر الاستعلام المحدّث

### `/show_limit <target>`
عرض الحدود بطرق متعددة

**الاستخدامات:**

#### 1. الحدود العامة:
```
/show_limit global
```
**النتيجة:**
```
🌍 الحدود العامة (Global Limits)

📊 الوضع: أسبوعي
📅 الحد اليومي: 2 كود
📆 السقف الأسبوعي: 6 كود
🚫 مدة الحظر: 7 أيام

💡 هذه الحدود تُطبق على جميع البوتات ما لم يكن لديها حدود خاصة
```

#### 2. حدود جميع البوتات:
```
/show_limit bot
```
**النتيجة:**
```
🤖 حدود البوتات (Bot Limits)

✅ بوتات لديها حدود خاصة:

• vipbot
  📆 أسبوعي: 5 كود/يوم, 20/أسبوع, حظر 3 أيام

• premiumbot
  📆 شهري: 10 كود/يوم, 100/شهر, حظر 7 أيام

🌍 بوتات تستخدم الحدود العامة:
• testbot
• normalbot
• mybot

💡 لتخصيص حدود لبوت: /set_weekly bot per_day cap ban
```

#### 3. حدود بوت محدد:
```
/show_limit bot/vipbot
```
**النتيجة (إذا كان لديه حدود خاصة):**
```
🤖 حدود البوت: vipbot

✅ حدود خاصة:

📊 الوضع: أسبوعي
📅 الحد اليومي: 5 كود
📆 السقف الأسبوعي: 20 كود
🚫 مدة الحظر: 3 أيام

💡 لحذف الحدود الخاصة: /bot_limit_clear vipbot
```

**النتيجة (إذا لم يكن لديه حدود خاصة):**
```
🤖 حدود البوت: testbot

🌍 يستخدم الحدود العامة:

📊 الوضع: أسبوعي
📅 الحد اليومي: 2 كود
📆 السقف الأسبوعي: 6 كود
🚫 مدة الحظر: 7 أيام

💡 لتخصيص حدود لهذا البوت: /set_weekly testbot per_day cap ban
```

#### 4. حدود حساب محدد:
```
/show_limit account/5
```
**النتيجة:**
```
🎮 حدود الحساب: mysteamaccount
🆔 ID: 5

⭐ حدود مخصصة (Override):

📊 الوضع: أسبوعي
📅 الحد اليومي: 3 كود
📆 السقف الأسبوعي: 10 كود
🚫 مدة الحظر: 7 أيام

💡 لحذف التجاوز: /override_clear 5
```

---

## 🧪 أمثلة عملية

### مثال 1: بوت VIP بحدود أعلى

```bash
# خطوة 1: إنشاء البوت
/addbot vipbot 1234567:ABC @vipchannel 500

# خطوة 2: تعيين حدود خاصة (أعلى من العامة)
/set_weekly vipbot 5 25 3

# خطوة 3: التحقق
/show_limit bot/vipbot

# النتيجة:
# ✅ البوت vipbot لديه حدود خاصة:
# - 5 كود/يوم (بدلاً من 2)
# - 25 كود/أسبوع (بدلاً من 6)
# - حظر 3 أيام (بدلاً من 7)
```

---

### مثال 2: بوت تجريبي بحدود أقل

```bash
# خطوة 1: إنشاء البوت
/addbot testbot 7654321:XYZ @testchannel 50

# خطوة 2: تعيين حد يومي بسيط
/set_daily testbot 1

# خطوة 3: التحقق
/show_limit bot/testbot

# النتيجة:
# ✅ البوت testbot لديه حدود خاصة:
# - 1 كود/يوم فقط
# - بدون حظر (رفض فوري)
```

---

### مثال 3: مقارنة الحدود

```bash
# عرض الحدود العامة
/show_limit global
→ 2 كود/يوم، 6/أسبوع

# عرض جميع البوتات
/show_limit bot

# عرض بوت محدد
/show_limit bot/vipbot
→ 5 كود/يوم، 20/أسبوع (حدود خاصة ✅)

/show_limit bot/normalbot
→ 2 كود/يوم، 6/أسبوع (حدود عامة 🌍)
```

---

### مثال 4: إزالة حدود خاصة

```bash
# البوت vipbot لديه حدود خاصة
/show_limit bot/vipbot
→ 5 كود/يوم، 20/أسبوع

# حذف الحدود الخاصة
/bot_limit_clear vipbot
→ ✅ تم حذف الحدود الخاصة

# الآن سيستخدم الحدود العامة
/show_limit bot/vipbot
→ 2 كود/يوم، 6/أسبوع (حدود عامة 🌍)
```

---

## 🎯 الأولويات (كيف يتم اختيار الحدود؟)

عندما يطلب مستخدم كوداً، يتم التحقق بهذا الترتيب:

```
1. هل هناك override للحساب؟
   ↓ نعم → استخدم override
   ↓ لا
   
2. هل هناك حدود خاصة للبوت؟
   ↓ نعم → استخدم حدود البوت
   ↓ لا
   
3. استخدم الحدود العامة
```

### مثال توضيحي:

```
البوت: vipbot
الحساب: account #5
المستخدم: user123

السيناريو A: الحساب #5 لديه override
→ النتيجة: استخدام حدود override (أعلى أولوية)

السيناريو B: الحساب #5 بدون override، لكن vipbot لديه حدود خاصة
→ النتيجة: استخدام حدود vipbot الخاصة

السيناريو C: لا override ولا حدود خاصة للبوت
→ النتيجة: استخدام الحدود العامة
```

---

## 📋 قائمة الأوامر الكاملة

### حدود عامة (Global):
```
/limit_mode_all <mode>
/set_daily_all <per_day>
/set_weekly_all <per_day> <cap> <ban>
/set_monthly_all <per_day> <cap> <ban>
```

### حدود البوتات (Bot-Specific): ⭐
```
/limit_mode <bot> <mode>
/set_daily <bot> <per_day>
/set_weekly <bot> <per_day> <cap> <ban>
/set_monthly <bot> <per_day> <cap> <ban>
/bot_limit_clear <bot>
```

### تجاوزات (Override):
```
/override_account <id> <mode> <per_day> [cap] [ban]
/override_clear <id>
```

### استعلام: ⭐
```
/show_limit global
/show_limit bot
/show_limit bot/<bot_label>
/show_limit account/<account_id>
```

### أخرى:
```
/reset_counters <target>
/ban_from_account <user> <account> <days>
/unban_from_account <user> <account>
/msg_set <event> <text>
/msg_show
```

---

*آخر تحديث: 2025-10-25*  
*النسخة: 2.0 - مع دعم حدود خاصة لكل بوت* ✅
