# ⚡ دليل البدء السريع - Quick Start Guide

**الوقت المتوقع:** 5-10 دقائق  
**المستوى:** مبتدئ

---

## 🎯 الهدف

نقل البيانات من `supehgku_Packagemaker` إلى `supehgku_test0` في **3 خطوات بسيطة**.

---

## ✅ المتطلبات

- [x] PHP 7.4+ مثبت
- [x] MySQL/MariaDB
- [x] صلاحية وصول للقاعدتين
- [x] 5 دقائق من وقتك

---

## 🚀 الخطوات

### الخطوة 1️⃣: تعديل الإعدادات (دقيقة واحدة)

افتح `config/migration_config.ini`:

```ini
[source_database]
username = root
password = your_password_here  ← ضع كلمة السر هنا
database = supehgku_Packagemaker

[target_database]
username = root
password = your_password_here  ← ضع كلمة السر هنا
database = supehgku_test0
```

**احفظ الملف.** ✅

---

### الخطوة 2️⃣: الاختبار (دقيقة واحدة)

افتح Terminal/CMD وانتقل إلى المجلد:

```bash
cd C:\Users\222222222qqqqqqqq\Downloads\bott111\migration_system\scripts
```

اختبر بدون تنفيذ فعلي:

```bash
php migrate.php
```

**في `migration_config.ini` تأكد أن:**
```ini
[migration_settings]
dry_run = true  ← إذا كنت تريد اختبار فقط
```

**ستشاهد:**
```
╔══════════════════════════════════════════════════════════╗
║                                                          ║
║         بدء نظام الترحيل التلقائي                      ║
║         الوضع: اختبار (Dry Run)                        ║
║                                                          ║
╚══════════════════════════════════════════════════════════╝

[INFO] اتصال ناجح بقاعدة المصدر
[INFO] اتصال ناجح بقاعدة الهدف
[DRY RUN] سيتم نقل 15 بوت
[DRY RUN] سيتم نقل 73 حساب
...
```

**إذا رأيت أخطاء:**
- تحقق من username/password
- تحقق من أسماء القواعد
- تحقق من أن MySQL يعمل

---

### الخطوة 3️⃣: التنفيذ الفعلي (2-5 دقائق)

غيّر في `migration_config.ini`:

```ini
[migration_settings]
dry_run = false  ← نفذ فعلياً
```

ثم شغّل:

```bash
php migrate.php
```

**انتظر... سترى:**

```
[SUCCESS] ✅ sub_bots: 15 منقول، 0 متخطى
[SUCCESS] ✅ steam_accounts: 73 منقول، 0 متخطى
[SUCCESS] ✅ allowed_users: 412 منقول، 0 متخطى
[SUCCESS] ✅ تم ربط 73 حساب بالمجموعة الافتراضية
[SUCCESS] ✅ تم ربط 15 بوت بالمجموعة الافتراضية
[SUCCESS] جميع الحسابات مربوطة بمجموعة ✅
[SUCCESS] جميع البوتات مربوطة بمجموعة ✅

🎉 اكتمل الترحيل بنجاح!
```

**تم! ✅**

---

## ✅ التحقق (دقيقة واحدة)

```bash
php verify.php
```

**النتيجة المطلوبة:**

```
═══════════════════════════════════════════════════════════
📊 التقرير النهائي
═══════════════════════════════════════════════════════════

🎉 ✅ جميع الفحوصات ناجحة!
النظام جاهز للعمل بشكل كامل.
```

---

## 🎯 اختبار النظام

### في قاعدة البيانات الجديدة:

```sql
-- عدد البوتات
SELECT COUNT(*) FROM sub_bots;

-- عدد الحسابات
SELECT COUNT(*) FROM steam_accounts;

-- عدد المستخدمين
SELECT COUNT(*) FROM allowed_users;

-- التحقق من الربط
SELECT COUNT(*) FROM group_accounts WHERE group_id = 1;
-- يجب أن يساوي عدد steam_accounts

SELECT COUNT(*) FROM bot_groups WHERE group_id = 1;
-- يجب أن يساوي عدد sub_bots
```

---

## ❓ ماذا بعد؟

### ✅ نجح الترحيل؟

**الآن يمكنك:**
1. استخدام النظام الجديد `supehgku_test0`
2. تعديل `control_bot.php` ليستخدم القاعدة الجديدة:
   ```php
   // في .env.php
   'DB_NAME' => 'supehgku_test0',
   ```
3. اختبار الأوامر الجديدة:
   - `/group_list`
   - `/bot_groups <bot>`
   - `/responses`

---

## ⚠️ إذا حدث خطأ

### استعادة النسخة الاحتياطية:

```bash
cd ../backups
# ابحث عن الملف
dir *.sql

# استعد
mysql -u root -p supehgku_test0 < backup_YYYYMMDD_HHMMSS.sql
```

### إعادة المحاولة:

```bash
# النظام idempotent - يمكن إعادة التشغيل بأمان
cd ../scripts
php migrate.php
```

---

## 📊 الملخص

| الخطوة | الوقت | الأمر |
|--------|-------|-------|
| 1. الإعدادات | 1 دقيقة | تعديل `migration_config.ini` |
| 2. الاختبار | 1 دقيقة | `php migrate.php` (dry_run=true) |
| 3. التنفيذ | 2-5 دقائق | `php migrate.php` (dry_run=false) |
| 4. التحقق | 1 دقيقة | `php verify.php` |

**الإجمالي:** 5-8 دقائق

---

## 💡 نصائح

### ✅ احتفظ بنسخة احتياطية
النظام ينشئها تلقائياً في `backups/`

### ✅ راجع السجلات
كل شيء مُسجّل في `logs/migration_*.log`

### ✅ يمكن إعادة التشغيل
إذا أضفت بيانات جديدة في القديمة، شغّل migrate.php مرة أخرى

### ✅ لا تحذف القديمة
احتفظ بها كـ backup

---

## 🎉 تهانينا!

أنت الآن تستخدم النظام الجديد المتقدم مع:

- ✅ نظام مجموعات
- ✅ نظام حدود ذكي
- ✅ نظام قسائم
- ✅ نظام ردود متقدم
- ✅ نظام بث
- ✅ والمزيد!

**🚀 استمتع!**

---

*آخر تحديث: 2025-10-25 04:25 UTC+03*
