﻿-- ============================================
-- تحديث قاعدة البيانات: إزالة النظام القديم
-- ============================================
-- التاريخ: 2025-10-24
-- الغرض: إزالة daily_attempts من الاستخدام
-- الطريقة: تعيين قيمة افتراضية لجميع البوتات
-- ============================================

-- الخطوة 1: تحديث جميع البوتات لقيمة افتراضية
-- (لا نحذف العمود للتوافق مع الكود القديم)
UPDATE sub_bots 
SET daily_attempts = 5
WHERE daily_attempts IS NULL OR daily_attempts = 0;

-- الخطوة 2: تحديث القيمة الافتراضية للعمود
ALTER TABLE sub_bots 
MODIFY COLUMN daily_attempts int(11) NOT NULL DEFAULT 5 
COMMENT 'معطّل - استخدم نظام الحدود الذكي (limits_global)';

-- ============================================
-- ملاحظات مهمة:
-- ============================================
-- 1. لم نحذف عمود daily_attempts للتوافق
-- 2. العمود موجود لكن sub_bot.php لا يقرأه
-- 3. استخدم نظام الحدود الذكي (limits_*) بدلاً منه
-- 4. الأوامر المعطلة: /setattempts

-- ============================================
-- التحقق من التطبيق:
-- ============================================
-- تأكد أن جميع البوتات لديها daily_attempts = 5
SELECT label, daily_attempts FROM sub_bots;

-- التحقق من نظام الحدود الذكي
SELECT * FROM limits_global;
SELECT * FROM limits_bot;
