-- ============================================
-- تحديث قسم الردود في message_templates
-- ============================================
-- التاريخ: 2025-10-25
-- الغرض: تحديث help_part7 (قسم الردود) بالأوامر الجديدة
-- ============================================

UPDATE message_templates 
SET text = '💬 <b>قسم الردود</b> (محسّن) ✨

💡 <i>نظام ردود متقدم: عامة لكل البوتات أو مخصصة لبوت واحد</i>

<b>📋 عرض الردود:</b>
<b>/responses</b> - عرض الردود العامة
<b>/bot_responses</b> <code>bot</code> - ردود بوت مخصصة 🆕
💡 <code>/bot_responses mybot</code>

<b>✏️ تعديل الردود العامة:</b>
<b>/edit_global_response</b> <code>key text</code> 🆕
➡️ يُحدّث رد عام لجميع البوتات
💡 <code>/edit_global_response start_1 مرحباً!</code>

<b>/editresponse</b> <code>key text</code>
➡️ نفس الأمر أعلاه (قديم)

<b>🤖 تعديل ردود بوت معين:</b>
<b>/edit_bot_response</b> <code>bot key text</code> 🆕
➡️ رد مخصص لبوت واحد فقط
💡 <code>/edit_bot_response mybot start_1 مرحباً في بوتي!</code>

<b>🔧 أوامر إضافية:</b>
<b>/copy_global_to_bot</b> <code>key bot</code> 🆕
➡️ نسخ رد عام ليصبح مخصص لبوت

<b>/delete_bot_response</b> <code>bot key</code> 🆕
➡️ حذف رد مخصص (يعود للرد العام)

<b>📚 القوالب المتاحة:</b>
• <code>start_1</code> - رسالة البداية
• <code>code_reply</code> - رد الكود
• <code>invalid_account</code> - حساب خاطئ
• <code>rate_limited</code> - تجاوز الحد
• <code>paused</code> - بوت متوقف'
WHERE `key` = 'help_part7';

-- التحقق
SELECT `key`, LEFT(text, 100) as preview, CHAR_LENGTH(text) as length
FROM message_templates 
WHERE `key` = 'help_part7';

SELECT '✅ تم تحديث قسم الردود بنجاح!' AS status;
