# 🤖 نظام إدارة بوتات Telegram - Steam Guard

**الإصدار:** v3.0  
**آخر تحديث:** 2025-10-25

---

## 📋 نظرة عامة

نظام متكامل لإدارة بوتات Telegram متعددة لتوليد أكواد Steam Guard مع:
- ✅ نظام مجموعات متقدم (Lock, Rename, Batch operations)
- ✅ نظام قسائم مع تتبع كامل
- ✅ نظام ردود مرن (عامة + مخصصة لكل بوت)

---

## 📁 هيكل المشروع

```
bott111/
├── 📄 control_bot.php          # البوت التحكمي الرئيسي ⭐
├── 📄 sub_bot.php              # البوتات الفرعية
├── 📄 README.md                # هذا الملف
├── 📄 INDEX.md                 # فهرس شامل للمشروع
│
├── 📂 lib/                     # المكتبات
│   ├── help_content.php        # محتوى المساعدة ⭐
│   ├── telegram.php            # وظائف Telegram API
│   └── helpers.php             # وظائف مساعدة
│
├── 📂 sql/                     # قاعدة البيانات
│   └── supehgku_test0.sql      # SQL النهائي الكامل ⭐
│
└── 📂 ARCHIVE/                 # الأرشيف
    ├── MIGRATIONS/             # ملفات Migration
    ├── DOCUMENTATION/          # التوثيق المفصل
    └── TESTS/                  # الاختبارات
```

---

## 🚀 التثبيت (3 خطوات)

### 1️⃣ قاعدة البيانات

```bash
mysql -u username -p database_name < sql/supehgku_test0.sql
```

### 2️⃣ الإعدادات

انسخ `.env.example` إلى `.env` وعدّل:
```env
CONTROL_BOT_TOKEN=your_control_bot_token
OWNER_USER_ID=your_telegram_id
DB_HOST=localhost
DB_NAME=database_name
DB_USER=username
DB_PASS=password
```

### 3️⃣ إعداد Webhook

```bash
curl "https://api.telegram.org/bot<TOKEN>/setWebhook?url=https://yourdomain.com/control_bot.php"
curl "https://api.telegram.org/bot<TOKEN>/setWebhook?url=https://yourdomain.com/sub_bot.php"
```

---

## 📊 الأوامر المتوفرة

### 🤖 إدارة البوتات
- `/addbot` - إضافة بوت جديد
- `/list` - عرض جميع البوتات
- `/pause` / `/unpause` - إيقاف/تشغيل بوت
- `/editbot` - تعديل إعدادات بوت

### 👤 إدارة الحسابات
- `/addaccount` - إضافة حساب Steam
- `/addaccounts` - إضافة دفعة حسابات
- `/accounts` - عرض الحسابات
- `/disableaccount` / `/enableaccount` - تعطيل/تفعيل

### 📂 إدارة المجموعات (15 أمر)
- `/group_add` - إنشاء مجموعة
- `/group_rename` - إعادة تسمية
- `/group_delete` - حذف مجموعة
- `/group_lock` / `/group_unlock` - قفل الحماية
- `/group_usage` - إحصائيات الاستخدام
- `/group_account_add` - إضافة حسابات (دفعات)
- `/group_account_del` - حذف حسابات (دفعات)
- `/bot_groups` - عرض مجموعات بوت
- `/groups_list` - عرض جميع المجموعات

### 🎫 إدارة القسائم
- `/generate_voucher` - إنشاء قسيمة
- `/vouchers` - عرض القسائم
- `/voucher_who_used` - تتبع الاستخدام 🆕

### 💬 إدارة الردود (6 أوامر جديدة)
- `/responses` - عرض الردود العامة
- `/edit_global_response` - تعديل رد عام 🆕
- `/edit_bot_response` - رد مخصص لبوت 🆕
- `/bot_responses` - عرض ردود بوت 🆕
- `/delete_bot_response` - حذف رد مخصص 🆕
- `/copy_global_to_bot` - نسخ رد 🆕

### 📊 الإحصائيات
- `/stats` - إحصائيات عامة
- `/user_stats` - إحصائيات مستخدم

---

## 🗄️ قاعدة البيانات

### الجداول الرئيسية
- `sub_bots` - البوتات الفرعية
- `steam_accounts` - حسابات Steam
- `account_groups` - مجموعات الحسابات
- `group_accounts` - علاقة المجموعات والحسابات
- `bot_groups` - علاقة البوتات والمجموعات
- `allowed_users` - المستخدمين المسموح لهم
- `vouchers` - القسائم
- `voucher_usage` - تتبع استخدام القسائم 🆕
- `message_templates` - الردود العامة
- `bot_message_templates` - الردود المخصصة 🆕
- `limit_messages` - رسائل الحدود
- `system_logs` - سجل النظام

---

## 🆕 الميزات الجديدة (v3.0)

### 1. نظام المجموعات المتقدم
- ✅ Lock/Unlock - حماية المجموعات من التعديل
- ✅ Rename - إعادة تسمية آمنة
- ✅ Batch Operations - إضافة/حذف حسابات بالدفعات
- ✅ Usage Statistics - إحصائيات مفصلة
- ✅ Case-insensitive - لا تكرار (VIP = vip)

### 2. نظام القسائم
- ✅ تتبع كامل - من استخدم القسيمة ومتى
- ✅ ربط بالبوت - معرفة البوت المستخدم

### 3. نظام الردود المرن
- ✅ ردود عامة - لجميع البوتات
- ✅ ردود مخصصة - لبوت واحد فقط
- ✅ أولويات - مخصص → عام → افتراضي
- ✅ سهل الإدارة - أوامر بسيطة

---

## 📚 التوثيق

### للبدء السريع (موصى به)
1. اقرأ `INDEX.md` - فهرس شامل للمشروع
2. راجع `ARCHIVE/DOCUMENTATION/QUICK_START.md`
3. راجع `ARCHIVE/DOCUMENTATION/RESPONSES_QUICK_START.md`

### للتفاصيل الكاملة
- `ARCHIVE/DOCUMENTATION/GROUPS_VOUCHERS_REPORT.md` (15 صفحة)
- `ARCHIVE/DOCUMENTATION/RESPONSES_SYSTEM_REPORT.md` (12 صفحة)
- `ARCHIVE/DOCUMENTATION/FINAL_SUMMARY.txt` (ملخص شامل)

### للتحديث من إصدار قديم
- `ARCHIVE/MIGRATIONS/` - جميع ملفات Migration
- `ARCHIVE/DOCUMENTATION/FIX_MIGRATION_ERROR.md` - حلول المشاكل

---

## 🧪 الاختبار

```bash
# اختبار قاعدة البيانات
mysql -u user -p database < ARCHIVE/TESTS/TESTS_GROUPS_VOUCHERS.sql

# اختبار البوت
/help groups      # يجب أن يعرض 9 أوامر
/help responses   # يجب أن يعرض 6 أوامر جديدة
/responses        # اختبار عرض الردود
```

---

## 🔧 استكشاف الأخطاء

### المشكلة: Migration فشل
**الحل:** راجع `ARCHIVE/DOCUMENTATION/FIX_MIGRATION_ERROR.md`

### المشكلة: الأمر لا يعمل
**الحل:**
1. تحقق من رفع `control_bot.php`
2. تحقق من تطبيق SQL
3. راجع `system_logs` في قاعدة البيانات

---

## 📊 الإحصائيات

- 📦 **الملفات:** 17
- 💻 **أسطر الكود:** ~2500
- 🆕 **الأوامر الجديدة:** 15
- 🗄️ **الجداول:** 15
- 📖 **صفحات التوثيق:** 40+

---

## 🔐 الأمان

- ✅ التحقق من المالك فقط (OWNER_USER_ID)
- ✅ حماية من المعالجة المكررة
- ✅ تسجيل جميع العمليات في system_logs
- ✅ SQL Prepared Statements (حماية من SQL injection)
- ✅ Validation على جميع المدخلات

---

## 🤝 المساهمة

هذا مشروع خاص. للاستفسارات أو التطوير، تواصل مع المطور.

---

## 📝 الترخيص

جميع الحقوق محفوظة © 2025

---

## 📞 الدعم

للدعم الفني أو الاستفسارات:
- راجع `INDEX.md` للفهرس الشامل
- راجع `ARCHIVE/DOCUMENTATION/` للتوثيق المفصل
- تحقق من `system_logs` في قاعدة البيانات

---

**🎉 جاهز للاستخدام!**
