<?php
/**
 * اختبار الاتصال بقواعد البيانات
 * شغّل هذا الملف أولاً للتحقق من أن كل شيء يعمل
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== اختبار الاتصال بقواعد البيانات ===\n\n";

// التحقق من وجود ملفات الإعداد
echo "1. التحقق من ملفات الإعداد...\n";
if (!file_exists(__DIR__ . '/config_source.php')) {
    die("❌ ERROR: ملف config_source.php غير موجود!\n");
}
if (!file_exists(__DIR__ . '/config_target.php')) {
    die("❌ ERROR: ملف config_target.php غير موجود!\n");
}
echo "✅ ملفات الإعداد موجودة\n\n";

// تحميل الإعدادات
echo "2. تحميل الإعدادات...\n";
try {
    $sourceConfig = require __DIR__ . '/config_source.php';
    echo "✅ تم تحميل config_source.php\n";
    echo "   - DB_NAME: " . $sourceConfig['DB_NAME'] . "\n";
    echo "   - DB_USER: " . $sourceConfig['DB_USER'] . "\n";
    
    $targetConfig = require __DIR__ . '/config_target.php';
    echo "✅ تم تحميل config_target.php\n";
    echo "   - DB_NAME: " . $targetConfig['DB_NAME'] . "\n";
    echo "   - DB_USER: " . $targetConfig['DB_USER'] . "\n\n";
} catch (Exception $e) {
    die("❌ ERROR: فشل تحميل الإعدادات: " . $e->getMessage() . "\n");
}

// اختبار PDO
echo "3. التحقق من PDO extension...\n";
if (!extension_loaded('pdo')) {
    die("❌ ERROR: PDO extension غير مفعّل!\n");
}
if (!extension_loaded('pdo_mysql')) {
    die("❌ ERROR: PDO MySQL driver غير مفعّل!\n");
}
echo "✅ PDO extensions جاهزة\n\n";

// اختبار الاتصال بقاعدة المصدر
echo "4. اختبار الاتصال بقاعدة المصدر...\n";
try {
    $dsn = "mysql:host={$sourceConfig['DB_HOST']};dbname={$sourceConfig['DB_NAME']};charset=utf8mb4";
    $pdo = new PDO($dsn, $sourceConfig['DB_USER'], $sourceConfig['DB_PASS'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    echo "✅ اتصال ناجح بقاعدة المصدر: {$sourceConfig['DB_NAME']}\n";
    
    // عد السجلات
    $stmt = $pdo->query("SELECT COUNT(*) as cnt FROM sub_bots");
    $count = $stmt->fetch()['cnt'];
    echo "   - عدد البوتات: $count\n";
    
    $stmt = $pdo->query("SELECT COUNT(*) as cnt FROM steam_accounts");
    $count = $stmt->fetch()['cnt'];
    echo "   - عدد الحسابات: $count\n\n";
    
} catch (PDOException $e) {
    echo "❌ ERROR: فشل الاتصال بقاعدة المصدر\n";
    echo "   الخطأ: " . $e->getMessage() . "\n\n";
    die("توقف البرنامج\n");
}

// اختبار الاتصال بقاعدة الهدف
echo "5. اختبار الاتصال بقاعدة الهدف...\n";
try {
    $dsn = "mysql:host={$targetConfig['DB_HOST']};dbname={$targetConfig['DB_NAME']};charset=utf8mb4";
    $pdo = new PDO($dsn, $targetConfig['DB_USER'], $targetConfig['DB_PASS'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    echo "✅ اتصال ناجح بقاعدة الهدف: {$targetConfig['DB_NAME']}\n";
    
    // التحقق من وجود الجداول
    $tables = ['sub_bots', 'steam_accounts', 'allowed_users', 'steam_requests'];
    foreach ($tables as $table) {
        try {
            $stmt = $pdo->query("SELECT COUNT(*) as cnt FROM `$table`");
            $count = $stmt->fetch()['cnt'];
            echo "   - جدول $table موجود (عدد السجلات: $count)\n";
        } catch (PDOException $e) {
            echo "   ⚠️  جدول $table: " . $e->getMessage() . "\n";
        }
    }
    
} catch (PDOException $e) {
    echo "❌ ERROR: فشل الاتصال بقاعدة الهدف\n";
    echo "   الخطأ: " . $e->getMessage() . "\n\n";
    die("توقف البرنامج\n");
}

echo "\n=== ✅ جميع الاختبارات نجحت! ===\n";
echo "يمكنك الآن تشغيل سكريبت الترحيل:\n";
echo "php migrate_core_no_templates.php --dry-run\n";
