# 📚 مرجع الأوامر الجديدة

## 📋 جدول المحتويات
1. [/group_details](#group_details)
2. [/bot_details](#bot_details)
3. [/account_details](#account_details)
4. [/bot_rename](#bot_rename)

---

## 🔍 /group_details

### الوصف
عرض معلومات تفصيلية عن مجموعة حسابات معينة.

### الصيغة
```
/group_details <group_name>
```

### المعاملات
- **group_name** (مطلوب): اسم المجموعة

### أمثلة
```
/group_details default
/group_details vip
/group_details premium
```

### الرد المتوقع
```
📂 معلومات المجموعة: vip ⭐ (افتراضية)

🔹 الحالة: ✅ نشطة
🔹 الوصف: مجموعة VIP للأعضاء المميزين

🤖 البوتات المرتبطة: (3)
1. ▶️ test1 (ID: 25)
2. ⏸️ test2 (ID: 26)
3. ▶️ test3 (ID: 27)

👤 الحسابات المرتبطة: (2)
1. ✅ Greatpackage1 (ID: 104)
2. ✅ pastoralshakyherring (ID: 105)
```

### رسائل الخطأ

#### المجموعة غير موجودة
```
❌ المجموعة test غير موجودة
```

#### صيغة خاطئة
```
❌ الاستخدام:
/group_details <group_name>

💡 مثال: /group_details default
```

### ملاحظات تقنية
- يعرض علامة ⭐ إذا كانت المجموعة افتراضية
- حالة البوتات: ▶️ نشط، ⏸️ متوقف
- حالة الحسابات: ✅ نشط، ❌ معطل
- جميع البيانات محمية بـ `htmlspecialchars()`

### استعلامات SQL
```sql
-- المجموعة
SELECT * FROM account_groups WHERE group_name=?

-- البوتات المرتبطة
SELECT sb.id, sb.label, sb.is_paused
FROM bot_groups bg
JOIN sub_bots sb ON sb.id = bg.bot_id
WHERE bg.group_id = ?
ORDER BY sb.label ASC

-- الحسابات المرتبطة
SELECT sa.id, sa.account_name, sa.active
FROM group_accounts ga
JOIN steam_accounts sa ON sa.id = ga.account_id
WHERE ga.group_id = ?
ORDER BY sa.account_name ASC
```

---

## 🤖 /bot_details

### الوصف
عرض معلومات تفصيلية عن بوت معين.

### الصيغة
```
/bot_details <bot_label>
```

### المعاملات
- **bot_label** (مطلوب): اسم/تسمية البوت

### أمثلة
```
/bot_details test1
/bot_details bot1
/bot_details premium_bot
```

### الرد المتوقع
```
🤖 معلومات البوت: test1

🔹 ID: 25
🔹 الحالة: ▶️ نشط
🔹 الحد الأقصى للمستخدمين: 1000

📂 المجموعات المرتبطة: (2)
1. ✅ default (ID: 1)
2. ✅ vip (ID: 6)

👤 الحسابات المرتبطة: (4)

   📁 default:
   1. ✅ greatpackagebot1 (ID: 42)
   2. ✅ greatpackage54 (ID: 102)

   📁 vip:
   3. ✅ Greatpackage1 (ID: 104)
   4. ✅ pastoralshakyherring (ID: 105)

⚙️ الحدود الخاصة بالبوت:
   • الوضع: يومي
   • الحد اليومي: 5 كود
   • الحد الأسبوعي: 30 كود
   • مدة الحظر: 7 يوم
```

### رسائل الخطأ

#### البوت غير موجود
```
❌ البوت test99 غير موجود
```

#### صيغة خاطئة
```
❌ الاستخدام:
/bot_details <bot_label>

💡 مثال: /bot_details test1
```

### ملاحظات تقنية
- حالة البوت: ▶️ نشط، ⏸️ متوقف
- حالة المجموعات: ✅ نشطة، ⛔ معطلة
- الحسابات مجمعة حسب المجموعة
- إذا لم توجد حدود خاصة، يعرض "يستخدم الحدود العامة"

### استعلامات SQL
```sql
-- البوت
SELECT * FROM sub_bots WHERE label=?

-- المجموعات المرتبطة
SELECT ag.id, ag.group_name, ag.active
FROM bot_groups bg
JOIN account_groups ag ON ag.id = bg.group_id
WHERE bg.bot_id = ?
ORDER BY ag.group_name ASC

-- الحسابات المرتبطة (عبر المجموعات)
SELECT DISTINCT sa.id, sa.account_name, sa.active, ag.group_name
FROM bot_groups bg
JOIN group_accounts ga ON ga.group_id = bg.group_id
JOIN steam_accounts sa ON sa.id = ga.account_id
JOIN account_groups ag ON ag.id = ga.group_id
WHERE bg.bot_id = ?
ORDER BY ag.group_name, sa.account_name ASC

-- الحدود الخاصة
SELECT * FROM limits_bot WHERE bot_label=?
```

---

## 👤 /account_details

### الوصف
عرض معلومات تفصيلية عن حساب Steam معين.

### الصيغة
```
/account_details <account_name أو ID>
```

### المعاملات
- **account_name|ID** (مطلوب): اسم الحساب أو رقم ID

### أمثلة
```
/account_details Greatpackage1
/account_details pastoralshakyherring
/account_details 104
/account_details 42
```

### الرد المتوقع
```
👤 معلومات الحساب: Greatpackage1

🔹 ID: 104
🔹 الحالة: ✅ نشط
🔹 Steam Guard: QvejS/EjSc...

📂 المجموعة المرتبطة:
   ✅ vip (ID: 6)

🤖 البوتات المرتبطة: (2)
   1. ▶️ test2 (ID: 28)
   2. ▶️ test3 (ID: 29)

⚙️ الحدود الخاصة:
   يستخدم حدود البوت أو الحدود العامة
   الأولوية: override → bot → global
```

### الرد مع حدود خاصة
```
⚙️ الحدود الخاصة:
   ✅ حدود خاصة بالحساب:
   • الوضع: يومي
   • الحد اليومي: 10 كود
   • السقف: 100 كود
   • مدة الحظر: 3 يوم
```

### رسائل الخطأ

#### الحساب غير موجود
```
❌ الحساب test123 غير موجود
```

#### صيغة خاطئة
```
❌ الاستخدام:
/account_details <account_name أو ID>

💡 مثال: /account_details steamuser123
أو: /account_details 42
```

### ملاحظات تقنية
- يدعم البحث بالاسم أو ID
- Steam Guard Secret: يعرض أول 10 أحرف فقط للأمان
- إذا كان shared_secret فارغ: يعرض "غير متوفر"
- حالة الحساب: ✅ نشط، ❌ معطل
- الحسابات بدون مجموعة: "لا توجد مجموعة مرتبطة"

### استعلامات SQL
```sql
-- البحث بالاسم
SELECT * FROM steam_accounts WHERE account_name=?

-- البحث بـ ID
SELECT * FROM steam_accounts WHERE id=?

-- المجموعة المرتبطة
SELECT ag.*
FROM group_accounts ga
JOIN account_groups ag ON ag.id = ga.group_id
WHERE ga.account_id = ?
LIMIT 1

-- البوتات المرتبطة (عبر المجموعة)
SELECT sb.id, sb.label, sb.is_paused
FROM bot_groups bg
JOIN sub_bots sb ON sb.id = bg.bot_id
WHERE bg.group_id = ?
ORDER BY sb.label ASC

-- الحدود الخاصة بالحساب
SELECT * FROM limits_override WHERE account_id=?
```

---

## ✏️ /bot_rename

### الوصف
تعديل اسم البوت مع تحديث جميع المراجع تلقائياً.

### الصيغة
```
/bot_rename <label_قديم> <label_جديد>
```

### المعاملات
- **label_قديم** (مطلوب): الاسم الحالي للبوت
- **label_جديد** (مطلوب): الاسم الجديد للبوت

### أمثلة
```
/bot_rename test1 test_new
/bot_rename old_bot new_bot
/bot_rename bot1 premium_bot
```

### الرد المتوقع
```
✅ تم تعديل اسم البوت بنجاح!

الاسم القديم: test1
الاسم الجديد: test_new

⚠️ ملاحظة: سيتم تحديث:
• الحدود الخاصة بالبوت
• العدادات المرتبطة
• الحظر المرتبط
تلقائياً (Foreign Key Cascade)
```

### رسائل الخطأ

#### البوت غير موجود
```
❌ البوت test99 غير موجود
```

#### الاسم الجديد موجود بالفعل
```
❌ الاسم test2 مستخدم بالفعل
```

#### صيغة خاطئة
```
❌ الاستخدام:
/bot_rename <label_قديم> <label_جديد>

💡 مثال: /bot_rename test1 test_new
```

### ملاحظات تقنية
- يحدث `UPDATE CASCADE` تلقائياً للجداول المرتبطة:
  - `limits_bot`
  - `limit_counters`
  - `limit_bans`
- التحقق من عدم وجود الاسم الجديد قبل التعديل
- جميع المراجع تُحدث تلقائياً عبر Foreign Keys

### استعلامات SQL
```sql
-- التحقق من البوت القديم
SELECT * FROM sub_bots WHERE label=?

-- التحقق من الاسم الجديد
SELECT * FROM sub_bots WHERE label=?

-- تعديل الاسم
UPDATE sub_bots SET label=? WHERE label=?

-- التحديثات التلقائية (Foreign Keys)
-- limits_bot: bot_label
-- limit_counters: يتبع cascade
-- limit_bans: يتبع cascade
```

---

## 🔐 معالجة الأمان

### htmlspecialchars
جميع الأوامر تستخدم `htmlspecialchars()` على:
- أسماء المجموعات
- أسماء البوتات
- أسماء الحسابات
- الأوصاف
- Steam Guard Secret
- أي بيانات من قاعدة البيانات

### مثال الاستخدام
```php
$group_name_safe = htmlspecialchars($group_name, ENT_QUOTES, 'UTF-8');
$out .= "📂 <b>معلومات المجموعة: {$group_name_safe}</b>\n";
```

### الأحرف المحمية
- `<` → `&lt;`
- `>` → `&gt;`
- `&` → `&amp;`
- `"` → `&quot;`
- `'` → `&#039;`

---

## ⚠️ معالجة الأخطاء

### نظام معالجة الأخطاء
```php
$send_result = tg_send($CONTROL_TOKEN, $chat_id, $out);
if (!($send_result['ok'] ?? false)) {
    tg_send($CONTROL_TOKEN, $chat_id, 
        "❌ فشل إرسال التفاصيل. الخطأ:\n" .
        "<code>" . htmlspecialchars($send_result['description'] ?? 'unknown', ENT_QUOTES, 'UTF-8') . "</code>\n\n" .
        "طول الرسالة: " . strlen($out) . " حرف"
    );
}
```

### رسائل الخطأ الشائعة

#### HTML Parsing Error
```
❌ فشل إرسال التفاصيل. الخطأ:
Bad Request: can't parse entities
```
**السبب:** أحرف HTML غير محمية  
**الحل:** تطبيق `htmlspecialchars()`

#### Message Too Long
```
❌ فشل إرسال التفاصيل. الخطأ:
Bad Request: message is too long
طول الرسالة: 4500 حرف
```
**السبب:** تجاوز حد 4096 حرف  
**الحل:** تقسيم الرسالة

---

## 📊 الأداء

### أوقات الاستجابة
- **`/group_details`**: ~50-100ms
- **`/bot_details`**: ~100-150ms
- **`/account_details`**: ~80-120ms
- **`/bot_rename`**: ~30-50ms

### حدود Telegram API
- **الحد الأقصى لطول الرسالة:** 4096 حرف
- **الحد الأقصى للطلبات:** 30 رسالة/ثانية

---

## 🧪 الاختبار

### ملفات الاختبار
- `test_commands.php` - اختبار `/group_details`
- `test_account_details.php` - اختبار `/account_details`

### كيفية الاختبار
```
1. ارفع الملف إلى السيرفر
2. افتح: https://yourdomain.com/test_commands.php
3. راجع النتائج:
   - بيانات قاعدة البيانات
   - محتوى الرسالة
   - نتيجة API
   - الأخطاء (إن وجدت)
```

---

## 📝 ملاحظات

### البيانات الفارغة
- **الوصف:** "لا يوجد"
- **shared_secret:** "غير متوفر"
- **المجموعة:** "لا توجد مجموعة مرتبطة"
- **البوتات:** "لا توجد بوتات مرتبطة"
- **الحسابات:** "لا توجد حسابات مرتبطة"

### الترتيب
- **المجموعات:** أبجدي (ASC)
- **البوتات:** أبجدي (ASC)
- **الحسابات:** أبجدي (ASC)
- **الحسابات في bot_details:** مجمعة حسب المجموعة

---

## 🔗 روابط ذات صلة

- [PROJECT_ANALYSIS.md](PROJECT_ANALYSIS.md) - تحليل المشروع
- [README.md](README.md) - الوثائق الرئيسية
- [CHANGELOG.md](CHANGELOG.md) - سجل التغييرات

---

**آخر تحديث:** 25 أكتوبر 2025  
**الإصدار:** 1.2.0
