# 🎯 نظام حدود البوتات - Bot-Specific Limits

**الحالة:** ✅ جاهز للدمج  
**التاريخ:** 2025-10-25  
**الموافقة:** لا تعارض مع النظام الحالي

---

## 🎉 ما تم إنجازه

تم إضافة نظام حدود متقدم يسمح بتخصيص حدود **لكل بوت على حدة**، بحيث يمكن لبعض البوتات أن تكون VIP بحدود أعلى، وأخرى تجريبية بحدود أقل.

---

## 📊 نظام الأولويات

```
1. limits_override  (حساب محدد)     ← أعلى أولوية
2. limits_bot       (بوت محدد)      ← أولوية متوسطة  
3. limits_global    (عام)           ← أدنى أولوية
```

**مثال:**
- البوت `vipbot` لديه حدود خاصة: 5 كود/يوم
- البوت `normalbot` ليس لديه حدود خاصة: يستخدم الحدود العامة 2 كود/يوم

---

## ✨ الأوامر الجديدة

### 1. `/limit_mode <bot> <mode>`
تغيير وضع البوت (daily/weekly/monthly)

```
/limit_mode vipbot weekly
```

### 2. `/set_daily <bot> <per_day>`
حد يومي بسيط

```
/set_daily testbot 1
→ كود واحد يومياً فقط
```

### 3. `/set_weekly <bot> <per_day> <cap> <ban>`
حد أسبوعي متقدم

```
/set_weekly vipbot 5 20 3
→ 5 كود/يوم، 20/أسبوع، حظر 3 أيام
```

### 4. `/set_monthly <bot> <per_day> <cap> <ban>`
حد شهري متقدم

```
/set_monthly premiumbot 10 100 7
→ 10 كود/يوم، 100/شهر، حظر 7 أيام
```

### 5. `/bot_limit_clear <bot>`
حذف الحدود الخاصة (العودة للحدود العامة)

```
/bot_limit_clear testbot
```

### 6. `/show_limit <target>` (محدّث)
عرض الحدود بطرق متعددة

```
/show_limit global          → الحدود العامة
/show_limit bot             → جميع البوتات
/show_limit bot/vipbot      → بوت محدد
/show_limit account/5       → حساب محدد
```

---

## 📂 الملفات

| الملف | الوصف |
|-------|-------|
| **BOT_LIMITS_COMMANDS.md** | شرح تفصيلي مع أمثلة |
| **bot_limits_implementation.php** | الأكواد الفعلية |
| **INTEGRATION_GUIDE.md** | دليل الدمج خطوة بخطوة |
| **BOT_LIMITS_README.md** | هذا الملف |

---

## 🚀 الدمج السريع

### خطوة 1: انسخ الدالة
من `bot_limits_implementation.php` → `control_bot.php`

```php
function getAppliedLimits($pdo, $bot_label, $account_id = null) {
    // ... الكود
}
```

### خطوة 2: انسخ الأوامر
من `bot_limits_implementation.php` → `switch ($command)` في `control_bot.php`

```php
case '/limit_mode':
case '/set_daily':
case '/set_weekly':
case '/set_monthly':
case '/bot_limit_clear':
case '/show_limit': // محدّث
```

### خطوة 3: استخدم الدالة الجديدة
عند التحقق من الحدود، استبدل:

```php
// القديم:
$limits = $pdo->query("SELECT * FROM limits_global WHERE id = 1")->fetch();

// الجديد:
$limits = getAppliedLimits($pdo, $bot_label, $account_id);
```

---

## 💡 أمثلة عملية

### مثال 1: بوت VIP
```bash
/addbot vipbot TOKEN @channel 500
/set_weekly vipbot 5 25 3
/show_limit bot/vipbot
```

**النتيجة:**
```
🤖 حدود البوت: vipbot
✅ حدود خاصة:
📊 الوضع: أسبوعي
📅 الحد اليومي: 5 كود
📆 السقف الأسبوعي: 25 كود
🚫 مدة الحظر: 3 أيام
```

### مثال 2: بوت تجريبي
```bash
/addbot testbot TOKEN @channel 50
/set_daily testbot 1
/show_limit bot/testbot
```

**النتيجة:**
```
🤖 حدود البوت: testbot
✅ حدود خاصة:
📊 الوضع: يومي
📅 الحد اليومي: 1 كود
🚫 مدة الحظر: بدون حظر
```

### مثال 3: عرض جميع البوتات
```bash
/show_limit bot
```

**النتيجة:**
```
🤖 حدود البوتات (Bot Limits)

✅ بوتات لديها حدود خاصة:
• vipbot
  📆 أسبوعي: 5 كود/يوم, 25/أسبوع, 🚫 3 أيام
• testbot
  📅 يومي: 1 كود/يوم

🌍 بوتات تستخدم الحدود العامة:
• normalbot
• mybot
```

---

## ✅ المميزات

- ✅ **لا تعارض** مع النظام الحالي
- ✅ **جدول موجود** - `limits_bot` موجود بالفعل في القاعدة
- ✅ **نظام أولويات** ذكي
- ✅ **مرونة كاملة** لكل بوت
- ✅ **سهل الدمج** - نسخ ولصق فقط
- ✅ **موثق بالكامل** - 3 ملفات توثيق

---

## ⚠️ ملاحظات مهمة

### 1. جدول limits_bot موجود ✅
لا حاجة لإنشاء الجدول، فهو موجود في قاعدة البيانات:

```sql
CREATE TABLE `limits_bot` (
  `bot_label` varchar(64) NOT NULL PRIMARY KEY,
  `mode` enum('daily','weekly','monthly') NOT NULL,
  `per_day` int(11) NOT NULL,
  `weekly_cap` int(11) DEFAULT NULL,
  `monthly_cap` int(11) DEFAULT NULL,
  `ban_days` int(11) DEFAULT NULL
)
```

### 2. الأولويات تلقائية
دالة `getAppliedLimits()` تتحقق من الأولويات تلقائياً:
1. هل هناك override؟ → نعم: استخدمه
2. هل هناك حد خاص للبوت؟ → نعم: استخدمه
3. استخدم الحد العام

### 3. الحدود العامة تبقى كما هي
النظام الجديد **لا يغير** الحدود العامة، بل يضيف طبقة إضافية اختيارية.

---

## 🧪 الاختبار

### اختبار 1: إنشاء بوت بحدود خاصة
```bash
/addbot testbot TOKEN @channel 100
/set_daily testbot 1
/show_limit bot/testbot
# يجب أن يظهر: 1 كود/يوم (حدود خاصة ✅)
```

### اختبار 2: حذف الحدود الخاصة
```bash
/bot_limit_clear testbot
/show_limit bot/testbot
# يجب أن يظهر: يستخدم الحدود العامة 🌍
```

### اختبار 3: مقارنة البوتات
```bash
/show_limit bot
# يجب أن يظهر: قائمة البوتات مع حدودها
```

---

## 📞 الدعم

### لمزيد من التفاصيل:
- **الأوامر:** راجع `BOT_LIMITS_COMMANDS.md`
- **الدمج:** راجع `INTEGRATION_GUIDE.md`
- **الأكواد:** راجع `bot_limits_implementation.php`

### إذا واجهت مشكلة:
1. تأكد من نسخ دالة `getAppliedLimits()` بالكامل
2. تأكد من نسخ جميع الأوامر الـ 6
3. تأكد من تحديث `case '/show_limit':`
4. اختبر بـ `/show_limit global` أولاً

---

## 🎯 الخلاصة

✅ نظام حدود متقدم لكل بوت  
✅ 6 أوامر جديدة + تحديث `/show_limit`  
✅ دالة `getAppliedLimits()` ذكية  
✅ لا تعارضات  
✅ جاهز للدمج فوراً  

**🚀 ابدأ الآن!**

---

*آخر تحديث: 2025-10-25*  
*النسخة: 2.0*  
*الحالة: ✅ جاهز للإنتاج*
