# 🚀 نظام الترحيل التلقائي - Auto Migration System

**النسخة:** 1.0.0  
**التاريخ:** 2025-10-25  
**الحالة:** ✅ جاهز للإنتاج

---

## 📋 نظرة عامة

نظام ترحيل احترافي وآمن لنقل البيانات من قاعدة `supehgku_Packagemaker` (القديمة) إلى `supehgku_test0` (الجديدة) مع الحفاظ على سلامة البيانات والعلاقات.

### ✨ الميزات الرئيسية

- ✅ **Idempotent** - يمكن إعادة التشغيل بأمان
- ✅ **Batch Processing** - معالجة بالدفعات للجداول الكبيرة
- ✅ **Auto Linking** - ربط تلقائي للبوتات والحسابات بالمجموعات
- ✅ **Dry Run Mode** - اختبار بدون تنفيذ فعلي
- ✅ **Detailed Logging** - سجل مفصل لكل عملية
- ✅ **Error Handling** - معالجة أخطاء قوية
- ✅ **Verification** - تحقق تلقائي بعد الترحيل
- ✅ **Backup** - نسخ احتياطية تلقائية

---

## 📂 هيكل المشروع

```
migration_system/
├── 📁 analysis/                 التحليلات والتقارير
│   ├── DATABASE_COMPARISON_REPORT.md
│   └── MIGRATION_PLAN.md
│
├── 📁 scripts/                  السكربتات التنفيذية
│   ├── migrate.php             السكربت الرئيسي
│   └── verify.php              سكربت التحقق
│
├── 📁 config/                   الإعدادات
│   └── migration_config.ini    ملف الإعدادات
│
├── 📁 logs/                     السجلات
│   └── migration_YYYYMMDD_HHMMSS.log
│
├── 📁 backups/                  النسخ الاحتياطية
│   └── backup_YYYYMMDD_HHMMSS.sql
│
└── 📄 README.md                 هذا الملف
```

---

## 🚀 البدء السريع

### 1️⃣ تهيئة الإعدادات

افتح `config/migration_config.ini` وعدّل:

```ini
[source_database]
host = localhost
username = root
password = your_password
database = supehgku_Packagemaker

[target_database]
host = localhost
username = root
password = your_password
database = supehgku_test0
```

### 2️⃣ اختبار (Dry Run)

```bash
cd migration_system/scripts
php migrate.php --dry-run
```

سيعرض ما سيتم ترحيله **بدون تنفيذ فعلي**.

### 3️⃣ التنفيذ الفعلي

```bash
php migrate.php
```

### 4️⃣ التحقق

```bash
php verify.php
```

---

## ⚙️ الإعدادات

### ملف `migration_config.ini`

#### قواعد البيانات
```ini
[source_database]
host = localhost
port = 3306
username = root
password = 
database = supehgku_Packagemaker
```

#### إعدادات الترحيل
```ini
[migration_settings]
batch_size = 1000              # حجم الدفعة
dry_run = false                # اختبار؟
enable_logging = true          # تسجيل؟
backup_before_migration = true # نسخ احتياطي؟
stop_on_error = true           # توقف عند خطأ؟
verify_after_migration = true  # تحقق بعد الترحيل؟
```

#### الجداول المطلوب ترحيلها
```ini
[tables_to_migrate]
sub_bots = 1
steam_accounts = 1
allowed_users = 1
message_templates = 1
steam_requests = 0    # معطل (كبير جداً)
control_sessions = 0  # معطل (قديم)
```

---

## 📊 ما يتم ترحيله؟

### ✅ البيانات الأساسية

| الجدول | الوصف | الاستراتيجية |
|--------|-------|--------------|
| `sub_bots` | البوتات الفرعية | نقل مباشر |
| `steam_accounts` | حسابات Steam | نقل مباشر |
| `allowed_users` | المستخدمون | نقل مباشر |
| `message_templates` | قوالب الرسائل | دمج (merge) |

### 🔗 الربط التلقائي

| العملية | الوصف |
|---------|-------|
| `group_accounts` | ربط كل حساب بالمجموعة الافتراضية (id=1) |
| `bot_groups` | ربط كل بوت بالمجموعة الافتراضية (id=1) |

### ⚠️ البيانات الاختيارية

| الجدول | الحالة | ملاحظات |
|--------|--------|----------|
| `steam_requests` | اختياري | قد يحتوي ملايين السجلات |
| `control_sessions` | اختياري | جلسات قديمة غير مطلوبة |

---

## 🔍 آلية العمل

### المرحلة 0️⃣: التحضير
```
1. التحقق من الاتصال بالقاعدتين
2. التحقق من وجود المجموعة الافتراضية (id=1)
3. إنشاء نسخة احتياطية
4. تعطيل Foreign Keys مؤقتاً
5. تهيئة ملف السجل
```

### المرحلة 1️⃣: البيانات الأساسية
```
1. نقل sub_bots
2. نقل steam_accounts
3. نقل allowed_users
4. دمج message_templates
```

### المرحلة 2️⃣: الربط
```
1. ربط كل حساب بـ group_id=1
2. ربط كل بوت بـ group_id=1
```

### المرحلة 3️⃣: البيانات الاختيارية
```
1. نقل steam_requests (إن كان مفعلاً)
2. توليد limit_counters
```

### المرحلة 4️⃣: التنظيف
```
1. إعادة تفعيل Foreign Keys
2. تحديث Auto Increment
3. التحقق من العلاقات
4. التحقق من البيانات اليتيمة
```

---

## 📝 السجلات (Logs)

### مثال على ملف السجل

```
[2025-10-25 04:00:00] INFO: ==================================================
[2025-10-25 04:00:00] INFO: بدء نظام الترحيل التلقائي
[2025-10-25 04:00:00] INFO: الوضع: تنفيذ حقيقي
[2025-10-25 04:00:01] SUCCESS: اتصال ناجح بقاعدة المصدر: supehgku_Packagemaker
[2025-10-25 04:00:01] SUCCESS: اتصال ناجح بقاعدة الهدف: supehgku_test0
[2025-10-25 04:00:02] INFO: === المرحلة 0: التحضير ===
[2025-10-25 04:00:02] SUCCESS: المجموعة الافتراضية (id=1) موجودة
[2025-10-25 04:00:05] SUCCESS: تم إنشاء نسخة احتياطية: backups/backup_20251025_040005.sql (12.5 MB)
[2025-10-25 04:00:05] INFO: تم تعطيل Foreign Keys مؤقتاً
[2025-10-25 04:00:05] INFO: === المرحلة 1: البيانات الأساسية ===
[2025-10-25 04:00:05] INFO: ترحيل جدول: sub_bots
[2025-10-25 04:00:05] INFO: عدد السجلات في المصدر: 15
[2025-10-25 04:00:05] SUCCESS: ✅ sub_bots: 15 منقول، 0 متخطى
[2025-10-25 04:00:06] INFO: ترحيل جدول: steam_accounts
[2025-10-25 04:00:06] INFO: عدد السجلات في المصدر: 73
[2025-10-25 04:00:06] SUCCESS: ✅ steam_accounts: 73 منقول، 0 متخطى
[2025-10-25 04:00:07] INFO: === المرحلة 2: ربط العلاقات ===
[2025-10-25 04:00:07] SUCCESS: ✅ تم ربط 73 حساب بالمجموعة الافتراضية
[2025-10-25 04:00:07] SUCCESS: ✅ تم ربط 15 بوت بالمجموعة الافتراضية
[2025-10-25 04:00:08] INFO: === المرحلة 4: التنظيف والتحقق ===
[2025-10-25 04:00:08] SUCCESS: تم إعادة تفعيل Foreign Keys
[2025-10-25 04:00:08] SUCCESS: جميع الحسابات مربوطة بمجموعة ✅
[2025-10-25 04:00:08] SUCCESS: جميع البوتات مربوطة بمجموعة ✅
[2025-10-25 04:00:08] INFO: ==================================================
[2025-10-25 04:00:08] SUCCESS: 🎉 اكتمل الترحيل بنجاح!
```

---

## ✅ التحقق من النجاح

بعد الترحيل، شغّل `verify.php`:

```bash
php scripts/verify.php
```

### النتيجة المتوقعة:

```
╔══════════════════════════════════════════════════════════╗
║                                                          ║
║          🔍 التحقق من الترحيل 🔍                       ║
║                                                          ║
╚══════════════════════════════════════════════════════════╝

═══════════════════════════════════════════════════════════
1️⃣ مقارنة عدد السجلات
═══════════════════════════════════════════════════════════

sub_bots            :    15 →    15 (0) ✅
steam_accounts      :    73 →    73 (0) ✅
allowed_users       :   412 →   412 (0) ✅
message_templates   :    19 →    19 (0) ✅

═══════════════════════════════════════════════════════════
2️⃣ التحقق من العلاقات
═══════════════════════════════════════════════════════════

steam_accounts        :    73
group_accounts (g=1)  :    73 ✅

sub_bots              :    15
bot_groups (g=1)      :    15 ✅

═══════════════════════════════════════════════════════════
📊 التقرير النهائي
═══════════════════════════════════════════════════════════

🎉 ✅ جميع الفحوصات ناجحة!
النظام جاهز للعمل بشكل كامل.
```

---

## ⚠️ استكشاف الأخطاء

### المشكلة: "المجموعة الافتراضية غير موجودة"

**الحل:**
```sql
INSERT INTO account_groups (id, group_name, description, is_default, locked) 
VALUES (1, 'default', 'المجموعة العامة', 1, 1);
```

### المشكلة: "Foreign Key Error"

**الحل:**
```bash
# تشغيل الترحيل سيعطل FK تلقائياً
# إذا استمر الخطأ، عطّلها يدوياً:
```
```sql
SET FOREIGN_KEY_CHECKS=0;
```

### المشكلة: "Memory Limit"

**الحل:**
```ini
# في migration_config.ini
[advanced]
memory_limit = 1024M
```

### المشكلة: "Execution Timeout"

**الحل:**
```ini
# في migration_config.ini
[advanced]
max_execution_time = 7200  # ساعتين
```

---

## 🔄 إعادة التشغيل (Idempotency)

النظام **idempotent** - يمكن إعادة تشغيله بأمان:

```bash
# التشغيل الأول
php migrate.php
# → ينقل كل شيء

# إضافة بوت جديد في القديمة...

# التشغيل الثاني
php migrate.php
# → ينقل الجديد فقط، يتخطى الموجود ✅
```

**كيف؟**
- `INSERT IGNORE` - يتخطى المكرر
- `ON DUPLICATE KEY UPDATE` - يحدّث الموجود
- التحقق قبل الإدراج

---

## 🆘 استعادة النسخة الاحتياطية

إذا حدث خطأ:

```bash
mysql -u username -p supehgku_test0 < backups/backup_20251025_040005.sql
```

---

## 📈 الأداء

### الوقت المتوقع

| عدد السجلات | الوقت |
|-------------|-------|
| < 1000 | < 10 ثانية |
| 1000-10,000 | 10-60 ثانية |
| 10,000-100,000 | 1-10 دقيقة |
| > 100,000 | 10-60 دقيقة |

### تحسين الأداء

1. **زيادة حجم الدفعة:**
   ```ini
   batch_size = 5000
   ```

2. **تعطيل السجل:**
   ```ini
   enable_logging = false
   ```

3. **تعطيل النسخ الاحتياطي:**
   ```ini
   backup_before_migration = false
   ```

---

## 📞 الدعم

إذا واجهت مشاكل:

1. راجع ملفات السجل في `logs/`
2. راجع `analysis/DATABASE_COMPARISON_REPORT.md`
3. راجع `analysis/MIGRATION_PLAN.md`

---

## 🎯 الخلاصة

✅ نظام ترحيل احترافي  
✅ آمن وقابل لإعادة التشغيل  
✅ سجل مفصل لكل عملية  
✅ تحقق تلقائي من النجاح  

**🚀 جاهز للإنتاج!**

---

*آخر تحديث: 2025-10-25 04:15 UTC+03*
