-- ================================================================
-- إضافة bot_label إلى limit_counters لجعل العدادات مستقلة لكل بوت
-- ================================================================
-- المشكلة: العدادات حالياً مشتركة بين جميع البوتات
-- الحل: إضافة bot_label إلى المفتاح الفريد
-- ================================================================

-- 1. عرض البنية الحالية
DESCRIBE limit_counters;

-- 2. حذف المفتاح الفريد القديم
ALTER TABLE `limit_counters` 
DROP INDEX `unique_user_account`;

-- 3. إضافة عمود bot_label
ALTER TABLE `limit_counters` 
ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`,
ADD INDEX `idx_bot` (`bot_label`);

-- 4. ملء bot_label للسجلات الموجودة (افتراضياً test1)
-- يمكنك تعديل هذا حسب احتياجك
UPDATE `limit_counters` 
SET `bot_label` = 'test1' 
WHERE `bot_label` IS NULL;

-- 5. جعل bot_label إجباري
ALTER TABLE `limit_counters` 
MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- 6. إضافة مفتاح فريد جديد (user_id, account_id, bot_label)
ALTER TABLE `limit_counters` 
ADD UNIQUE KEY `unique_user_account_bot` (`user_id`, `account_id`, `bot_label`);

-- 7. إضافة foreign key لـ bot_label
ALTER TABLE `limit_counters`
ADD CONSTRAINT `fk_counters_bot` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

-- 8. التحقق من النتيجة
SELECT 
    TABLE_NAME,
    COLUMN_NAME,
    COLUMN_TYPE,
    IS_NULLABLE,
    COLUMN_KEY
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = 'supehgku_test0'
  AND TABLE_NAME = 'limit_counters'
ORDER BY ORDINAL_POSITION;

-- 9. عرض المفاتيح
SHOW INDEX FROM `limit_counters`;

-- ================================================================
-- النتيجة:
-- ================================================================
-- الآن كل بوت له عداداته المستقلة:
-- - test1 → عدادات خاصة
-- - test2 → عدادات خاصة
-- - test3 → عدادات خاصة
--
-- نفس المستخدم + نفس الحساب في بوتات مختلفة = عدادات منفصلة!
-- ================================================================
