-- ================================================================
-- الحل المبسط: عزل الحدود لكل بوت
-- ================================================================
-- بدون أوامر عرض - جاهز للتنفيذ مباشرة
-- ================================================================

START TRANSACTION;

-- ═══════════════════════════════════════════════════════════════
-- الجزء 1: تعديل limit_counters
-- ═══════════════════════════════════════════════════════════════

ALTER TABLE `limit_counters` DROP INDEX IF EXISTS `unique_user_account`;

ALTER TABLE `limit_counters` ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

ALTER TABLE `limit_counters` ADD INDEX `idx_bot_counters` (`bot_label`);

UPDATE `limit_counters` SET `bot_label` = 'test1' WHERE `bot_label` IS NULL;

ALTER TABLE `limit_counters` MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

ALTER TABLE `limit_counters` ADD UNIQUE KEY `unique_user_account_bot` (`user_id`, `account_id`, `bot_label`);

ALTER TABLE `limit_counters`
ADD CONSTRAINT `fk_counters_bot_label` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

-- ═══════════════════════════════════════════════════════════════
-- الجزء 2: تعديل limit_bans
-- ═══════════════════════════════════════════════════════════════

ALTER TABLE `limit_bans` DROP INDEX IF EXISTS `unique_user_account_ban`;

ALTER TABLE `limit_bans` ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;

ALTER TABLE `limit_bans` ADD INDEX `idx_bot_bans` (`bot_label`);

UPDATE `limit_bans` SET `bot_label` = 'test1' WHERE `bot_label` IS NULL;

ALTER TABLE `limit_bans` MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

ALTER TABLE `limit_bans` ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`, `account_id`, `bot_label`);

ALTER TABLE `limit_bans`
ADD CONSTRAINT `fk_bans_bot_label` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

COMMIT;

-- ================================================================
-- ✅ تم التطبيق بنجاح!
-- ================================================================
-- الآن كل بوت له عداداته وحظره المستقل
-- 
-- لا تنسَ رفع الملفات المحدثة:
-- • lib/limits.php
-- • lib/limits_core.php
-- ================================================================
