-- ================================================================
-- 🔥 إصلاح عاجل: إزالة الحظر السابق + تصحيح البيانات
-- ================================================================
-- المشكلة: 
-- 1. المستخدم 5458195623 محظور حتى 2028 (1000+ يوم!)
-- 2. الحظر تم بنظام الحدود القديمة
-- 3. البوت الفرعي يفحص الحظر أولاً قبل فحص الحدود الجديدة
-- ================================================================

-- 1. حذف جميع الحظر السابق (مهم!)
DELETE FROM limit_bans;

-- 2. إعادة تعيين العدادات لجميع المستخدمين
UPDATE limit_counters 
SET day_used = 0, 
    week_used = 0, 
    month_used = 0,
    day_reset_at = DATE_ADD(NOW(), INTERVAL 1 DAY),
    week_reset_at = DATE_ADD(DATE_ADD(CURDATE(), INTERVAL (7 - WEEKDAY(CURDATE())) DAY), INTERVAL 1 WEEK),
    month_reset_at = DATE_FORMAT(DATE_ADD(NOW(), INTERVAL 1 MONTH), '%Y-%m-01 00:00:00');

-- 3. التحقق من limits_bot (يجب أن تكون موجودة)
SELECT 
    bot_label,
    mode,
    per_day,
    weekly_cap,
    monthly_cap,
    ban_days
FROM limits_bot;

-- 4. التحقق من sub_bots (يجب أن تكون الأسماء صحيحة)
SELECT id, label FROM sub_bots WHERE id IN (27, 28, 29);

-- 5. التحقق: لا يوجد حظر نشط
SELECT COUNT(*) as 'عدد الحظر النشط (يجب أن يكون 0)' 
FROM limit_bans 
WHERE banned_until > NOW();

-- 6. عرض الحدود العامة
SELECT * FROM limits_global;

-- ================================================================
-- الآن جرّب في البوت الفرعي:
-- ================================================================
-- يجب أن يعطيك 10000 كود/يوم بدون حظر!
-- ================================================================

-- ملاحظة: إذا لم يعمل بعد ذلك، المشكلة في:
-- 1. البوت label في sub_bots لا يتطابق مع bot_label في limits_bot
-- 2. أو هناك cache في PHP (أعد تشغيل الويب سيرفر)
-- ================================================================
