-- ===============================================
-- التحقق من حدود البوتات المُضافة
-- ===============================================

-- 1. عرض جميع البوتات وحدودها
SELECT 
    sb.id,
    sb.label as bot_name,
    lb.mode,
    lb.per_day,
    lb.weekly_cap,
    lb.monthly_cap,
    lb.ban_days,
    CASE 
        WHEN lb.bot_label IS NOT NULL THEN 'حدود خاصة ✅'
        ELSE 'حدود عامة 🌍'
    END as limit_type
FROM sub_bots sb
LEFT JOIN limits_bot lb ON lb.bot_label = sb.label
ORDER BY sb.id;

-- 2. عرض الحدود العامة
SELECT * FROM limits_global;

-- 3. عرض البوتات التي لها حدود خاصة فقط
SELECT * FROM limits_bot;
