<?php
/**
 * اختبار أمر /responses بشكل مباشر
 * افتح من المتصفح: https://yourdomain.com/test_responses.php
 */

require __DIR__ . '/lib/telegram.php';

header('Content-Type: text/html; charset=utf-8');

$db = pdo();

echo "<h1>اختبار أمر /responses</h1>";
echo "<hr>";

try {
    echo "<h2>1. محاولة القراءة من قاعدة البيانات:</h2>";
    $rows = $db->query("SELECT `key`,`text` FROM message_templates ORDER BY `key` ASC")->fetchAll();
    echo "<p style='color: green;'>✅ نجح! عدد الصفوف: " . count($rows) . "</p>";
    
    if (count($rows) == 0) {
        echo "<p style='color: red;'>❌ الجدول فارغ!</p>";
        exit;
    }
    
    echo "<h2>2. بناء الرسالة:</h2>";
    $out = "🗂 <b>الردود العامة (Global Templates):</b>\n\n";
    $out .= "📊 <b>العدد:</b> " . count($rows) . "\n\n";
    
    foreach ($rows as $r) {
        $preview = mb_substr($r['text'], 0, 80);
        if (mb_strlen($r['text']) > 80) {
            $preview .= '...';
        }
        // هروب HTML entities لتجنب التضارب
        $preview_escaped = htmlspecialchars($preview, ENT_QUOTES, 'UTF-8');
        
        $out .= "🔹 <code>{$r['key']}</code>\n";
        $out .= "   {$preview_escaped}\n\n";
    }
    
    echo "<p style='color: green;'>✅ تم بناء الرسالة بنجاح!</p>";
    echo "<p>طول الرسالة: " . strlen($out) . " حرف</p>";
    
    echo "<h2>3. معاينة الرسالة:</h2>";
    echo "<div style='background: #f5f5f5; padding: 20px; border: 1px solid #ddd; direction: rtl;'>";
    echo nl2br(htmlspecialchars($out));
    echo "</div>";
    
    echo "<h2>4. اختبار الإرسال:</h2>";
    
    // جرّب الإرسال
    $cfg = env_cfg();
    $CONTROL_TOKEN = $cfg['CONTROL_BOT_TOKEN'];
    $OWNER = (int)$cfg['OWNER_USER_ID'];
    
    echo "<p>سيتم الإرسال إلى: {$OWNER}</p>";
    
    // استخدم tg_call مباشرة لنرى النتيجة
    $result = tg_call($CONTROL_TOKEN, 'sendMessage', [
        'chat_id' => $OWNER,
        'text' => $out,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);
    
    echo "<h3>النتيجة الكاملة:</h3>";
    echo "<pre style='background: #f5f5f5; padding: 15px; border: 1px solid #ddd;'>";
    echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    echo "</pre>";
    
    if (isset($result['ok']) && $result['ok']) {
        echo "<p style='color: green; font-size: 18px; font-weight: bold;'>✅ تم الإرسال بنجاح!</p>";
    } else {
        echo "<p style='color: red; font-size: 18px; font-weight: bold;'>❌ فشل الإرسال!</p>";
        
        if (isset($result['description'])) {
            echo "<div style='background: #ffebee; padding: 20px; border-left: 4px solid #f44336; margin: 10px 0;'>";
            echo "<h3 style='color: #c62828;'>⚠️ سبب الفشل:</h3>";
            echo "<p style='font-size: 16px;'>" . htmlspecialchars($result['description']) . "</p>";
            
            // تحليل الخطأ
            if (strpos($result['description'], 'parse') !== false || strpos($result['description'], 'HTML') !== false) {
                echo "<div style='background: #fff3cd; padding: 15px; margin-top: 10px; border: 1px solid #ffc107;'>";
                echo "<h4>💡 الحل المحتمل:</h4>";
                echo "<p>المشكلة في HTML! جرّب إرسال بدون HTML:</p>";
                echo "<p><code>parse_mode = null</code></p>";
                echo "</div>";
            }
            echo "</div>";
        }
        
        if (isset($result['error_code'])) {
            echo "<p>كود الخطأ: <strong>{$result['error_code']}</strong></p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ خطأ: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
