# 📋 مرجع الأوامر الكامل (Commands Reference)

## جميع أوامر النظام - مُحدّث 2024

---

## 🆕 الأوامر الجديدة (27 أمر)

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/users_count` | عرض عدد المستخدمين فقط | `/users_count` |
| `/group_bind_multi` | ربط عدة بوتات بمجموعة | `/group_bind_multi 36k bot1 bot2 bot3` |
| `/group_unbind_multi` | فصل عدة بوتات من مجموعة | `/group_unbind_multi 36k bot1 bot2` |
| `/set_user_limit` | تعيين حد لمستخدم | `/set_user_limit 123456 daily 20` |
| `/clear_user_limit` | إزالة حد مستخدم | `/clear_user_limit 123456` |
| `/show_user_limit` | عرض حدود مستخدم | `/show_user_limit 123456` |
| `/webhook_create` | إنشاء رابط Webhook | `/webhook_create test1` |
| `/webhook_enable` | تفعيل Webhook | `/webhook_enable test1` |
| `/webhook_reset` | إعادة ضبط Webhook | `/webhook_reset test1` |
| `/webhook_delete` | حذف Webhook | `/webhook_delete test1` |
| `/webhook_info` | معلومات Webhook | `/webhook_info test1` |
| `/stats_bots` | إحصاءات البوتات | `/stats_bots` |
| `/stats_users` | إحصاءات المستخدمين | `/stats_users` |
| `/stats_groups` | إحصاءات المجموعات | `/stats_groups` |
| `/stats_vouchers` | إحصاءات القسائم | `/stats_vouchers` |
| `/stats_broadcast` | إحصاءات البث | `/stats_broadcast` |
| `/stats_all` | ملخص شامل | `/stats_all` |
| `/response_add` | إضافة رد | `/response_add key text` |
| `/response_edit` | تعديل رد | `/response_edit key new_text` |
| `/response_delete` | حذف رد | `/response_delete key` |
| `/response_list` | عرض جميع الردود | `/response_list` |
| `/response_view` | عرض رد محدد | `/response_view key` |
| `/show_welcome_messages` | عرض رسائل الترحيب | `/show_welcome_messages` |

---

## 🤖 إدارة البوتات

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/addbot` | إضافة بوت جديد | `/addbot mybot 123:ABC` |
| `/list` ✨ | عرض جميع البوتات (محسّن) | `/list` |
| `/pause` | إيقاف مؤقت لبوت | `/pause test1` |
| `/resume` | استئناف بوت | `/resume test1` |
| `/deletebot` | حذف بوت | `/deletebot test1` |
| `/refreshbot` | تحديث توكن | `/refreshbot test1` |
| `/setmax` | تعيين الحد الأقصى | `/setmax test1 1000` |
| `/setchannel` | تعيين قناة | `/setchannel test1 @channel` |
| `/setwelcome` | تعيين رسالة ترحيب | `/setwelcome test1` |

---

## 👥 إدارة المستخدمين

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/users` | مستخدمو بوت | `/users test1` |
| `/allusers` ✨ | جميع المستخدمين (محسّن) | `/allusers` |
| `/users_count` 🆕 | عدد المستخدمين فقط | `/users_count` |
| `/checkuser` | البحث عن مستخدم | `/checkuser 123456` |
| `/ban` | حظر مستخدم | `/ban 123456 test1` |
| `/unban` | إلغاء حظر | `/unban 123456 test1` |
| `/adduser` | إضافة يدوياً | `/adduser test1 123456` |
| `/kickuser` | طرد مستخدم | `/kickuser test1 123456` |

---

## 📂 إدارة المجموعات

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/group_add` | إنشاء مجموعة | `/group_add 36k` |
| `/groups_list` ✨ | عرض الكل (محسّن) | `/groups_list` |
| `/group_info` | معلومات مجموعة | `/group_info 36k` |
| `/group_toggle` | تفعيل/تعطيل | `/group_toggle 36k` |
| `/group_bind` | ربط بوت بمجموعة | `/group_bind test1 36k` |
| `/group_unbind` | فصل بوت | `/group_unbind test1 36k` |
| `/group_bind_multi` 🆕 | ربط متعدد | `/group_bind_multi 36k bot1 bot2` |
| `/group_unbind_multi` 🆕 | فصل متعدد | `/group_unbind_multi 36k bot1 bot2` |
| `/group_account_add` | إضافة حسابات | `/group_account_add 36k acc1 acc2` |
| `/group_account_remove` | إزالة حسابات | `/group_account_remove 36k acc1` |

---

## 🎫 نظام القسائم

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/generate_voucher` ✨ | إنشاء قسيمة (محسّن) | `/generate_voucher users 100 group:36k` |
| `/redeem` ✨ | تفعيل قسيمة (محسّن) | `/redeem VXXXX test1` |
| `/vouchers` | عرض القسائم | `/vouchers` |
| `/voucher_search` | البحث | `/voucher_search VXX` |

**صيغ جديدة لـ /generate_voucher**:
- `/generate_voucher users 100` - قسيمة عامة
- `/generate_voucher users 50 test1` - لبوت محدد
- `/generate_voucher users 200 group:36k 5` - لمجموعة محددة 🆕

---

## ⚙️ نظام الحدود

### الحدود العامة

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/set_daily_all` | حد يومي عام | `/set_daily_all 5` |

### حدود البوتات

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/limit_mode` | تعيين حد لبوت | `/limit_mode test1 daily 10` |

### حدود الحسابات

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/override_account` | حد لحساب | `/override_account 5 daily 20` |
| `/override_clear` | إزالة حد | `/override_clear 5` |

### حدود المستخدمين 🆕

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/set_user_limit` | تعيين حد | `/set_user_limit 123456 weekly 5 20 7` |
| `/clear_user_limit` | إزالة حد | `/clear_user_limit 123456` |
| `/show_user_limit` | عرض حدود | `/show_user_limit 123456` |

### عرض الحدود

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/show_limit` | عرض حدود | `/show_limit global` |
|  | | `/show_limit bot/test1` |
|  | | `/show_limit 5` (حساب) |

---

## 📢 نظام البث

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/broadcast` | بث لبوت | `/broadcast test1 مرحباً` |
| `/broadcast_all` | بث للكل | `/broadcast_all إعلان مهم` |
| `/broadcast_log` | سجل البث | `/broadcast_log test1` |

**ملاحظة**: تم إصلاح مشكلة التكرار في البوتات الفرعية ✅

---

## 🔗 Webhook 🆕

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/webhook_create` | إنشاء رابط | `/webhook_create test1` |
| `/webhook_enable` | تفعيل | `/webhook_enable test1` |
| `/webhook_reset` | إعادة ضبط | `/webhook_reset test1` |
| `/webhook_delete` | حذف | `/webhook_delete test1` |
| `/webhook_info` | معلومات | `/webhook_info test1` |

---

## 📊 الإحصاءات والتقارير 🆕

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/stats_bots` | إحصاءات البوتات | `/stats_bots` |
| `/stats_users` | إحصاءات المستخدمين | `/stats_users` |
| `/stats_groups` | إحصاءات المجموعات | `/stats_groups` |
| `/stats_vouchers` | إحصاءات القسائم | `/stats_vouchers` |
| `/stats_broadcast` | إحصاءات البث | `/stats_broadcast` |
| `/stats_all` | ملخص شامل | `/stats_all` |

---

## 📝 إدارة الردود 🆕

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/response_add` | إضافة رد | `/response_add key text` |
| `/response_edit` | تعديل رد | `/response_edit key new_text` |
| `/response_delete` | حذف رد | `/response_delete key` |
| `/response_list` | عرض الكل | `/response_list` |
| `/response_view` | عرض رد | `/response_view key` |

---

## 🎮 إدارة الحسابات

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/addaccount` | إضافة حساب | `/addaccount acc1 secret` |
| `/deleteaccount` | حذف حساب | `/deleteaccount acc1` |
| `/accounts` | عرض الحسابات | `/accounts` |

---

## 📚 المساعدة

| الأمر | الوصف | مثال |
|-------|-------|------|
| `/help` | المساعدة الرئيسية | `/help` |
| `/help bots` | مساعدة البوتات | `/help bots` |
| `/help users` | مساعدة المستخدمين | `/help users` |
| `/help groups` | مساعدة المجموعات | `/help groups` |
| `/help vouchers` | مساعدة القسائم | `/help vouchers` |
| `/help limits` | مساعدة الحدود | `/help limits` |
| `/help broadcast` | مساعدة البث | `/help broadcast` |
| `/help stats` 🆕 | مساعدة الإحصاءات | `/help stats` |
| `/help responses` 🆕 | مساعدة الردود | `/help responses` |

---

## 🔑 الرموز والعلامات

| الرمز | المعنى |
|------|--------|
| 🆕 | أمر جديد تماماً |
| ✨ | أمر محسّن/معدّل |
| ✅ | تم إصلاح مشكلة |
| ⚠️ | يحتاج انتباه |

---

## 📊 إحصاءات الأوامر

### الأوامر حسب الفئة

| الفئة | عدد الأوامر | أوامر جديدة |
|------|-------------|-------------|
| إدارة البوتات | 10 | 1 |
| إدارة المستخدمين | 9 | 1 |
| إدارة المجموعات | 10 | 2 |
| نظام القسائم | 4 | 0 |
| نظام الحدود | 9 | 3 |
| نظام البث | 3 | 0 |
| Webhook | 5 | 5 |
| الإحصاءات | 6 | 6 |
| الردود | 5 | 5 |
| المساعدة | 9 | 2 |
| **الإجمالي** | **70** | **27** |

---

## 🎯 أوامر سريعة مهمة

### للاستخدام اليومي

```
/stats_all              # نظرة سريعة
/users_count            # عدد المستخدمين
/groups_list            # حالة المجموعات
/list                   # البوتات
```

### لحل المشاكل

```
/webhook_info bot       # حالة Webhook
/webhook_reset bot      # إعادة ضبط
/show_limit global      # الحدود العامة
/broadcast_log bot      # سجل البث
```

### للإدارة المتقدمة

```
/group_bind_multi       # ربط متعدد
/set_user_limit         # حد مخصص
/generate_voucher       # قسيمة مع مجموعة
/stats_users            # الأكثر نشاطاً
```

---

## 📖 أمثلة عملية

### مثال 1: إعداد مجموعة VIP كاملة

```bash
/group_add vip
/group_account_add vip acc1 acc2 acc3
/group_bind_multi vip bot_vip1 bot_vip2
/generate_voucher users 500 group:vip 10
/set_user_limit 123456 daily 50
```

### مثال 2: مراقبة يومية

```bash
/stats_all
/stats_users
/users_count
/groups_list
```

### مثال 3: إصلاح مشكلة Webhook

```bash
/webhook_info test1
/webhook_reset test1
/webhook_info test1
```

---

## 🔍 نصائح البحث السريع

- **للبحث عن أمر**: `Ctrl+F` في هذا الملف
- **لعرض أمر معين**: `/help <category>`
- **لاختبار أمر**: جرّبه في بوت التحكم مباشرة

---

## ✅ الخلاصة

- **إجمالي الأوامر**: 70 أمر
- **أوامر جديدة**: 27 أمر
- **فئات**: 10 فئات
- **أوامر محسّنة**: 6 أوامر

---

**آخر تحديث**: نوفمبر 2024  
**الحالة**: محدّث بالكامل ✅  
**المرجع**: للاستخدام اليومي

---

💡 **نصيحة**: احفظ هذا الملف للرجوع إليه!
