# تقرير بنية النظام العامة (Architecture Overview)

## 📋 وصف عام للنظام

هذا النظام عبارة عن **منصة إدارة مركزية لعدة بوتات تيليجرام** تقدم خدمة توليد أكواد Steam Guard للمستخدمين. النظام مكتوب بلغة **PHP** ويستخدم قاعدة بيانات **MySQL/MariaDB**.

### المكونات الرئيسية:
1. **بوت التحكم المركزي** (Control Bot) - واجهة إدارة للمالك
2. **البوتات الفرعية** (Sub Bots) - بوتات خدمة للمستخدمين النهائيين
3. **نظام الحدود الذكي** (Smart Limits) - للتحكم في الاستخدام
4. **نظام المجموعات** (Groups) - لتنظيم الحسابات والبوتات
5. **نظام القسائم** (Vouchers) - لزيادة المستخدمين أو الأيام

---

## 📁 الملفات الرئيسية

### 1. الملفات الأساسية في الجذر

| الملف | الوظيفة | عدد الأسطر |
|-------|---------|-----------|
| `control_bot.php` | بوت التحكم المركزي - واجهة المالك | ~3012 |
| `sub_bot.php` | البوتات الفرعية - واجهة المستخدمين | ~712 |
| `.env.php` | إعدادات قاعدة البيانات والدومين | 11 |
| `cron_limits_maintenance.php` | صيانة دورية لنظام الحدود | 44 |
| `main.sql.sql` | قاعدة البيانات الكاملة | ~10064 |

### 2. مجلد المكتبات `lib/`

| الملف | الوظيفة | عدد الأسطر |
|-------|---------|-----------|
| `telegram.php` | دوال Telegram API + قاعدة البيانات | 209 |
| `steam.php` | توليد أكواد Steam Guard | 27 |
| `limits_core.php` | الدالة الرئيسية لنظام الحدود | 273 |
| `limits.php` | دوال مساعدة لنظام الحدود | 195 |
| `help_content.php` | محتوى قوائم المساعدة | 322 |

---

## 🔄 معمارية النظام

```
┌─────────────────────────────────────────────────────────┐
│                     Telegram Bot API                     │
└────────────────────┬────────────────────────────────────┘
                     │
         ┌───────────┴───────────┐
         │                       │
┌────────▼─────────┐   ┌────────▼─────────┐
│  Control Bot     │   │   Sub Bots       │
│  (المالك فقط)    │   │  (المستخدمون)   │
│                  │   │                  │
│  control_bot.php │   │  sub_bot.php     │
└────────┬─────────┘   └────────┬─────────┘
         │                      │
         │   ┌──────────────────┘
         │   │
    ┌────▼───▼────────────────────────┐
    │      MySQL Database              │
    │  ┌──────────────────────────┐   │
    │  │ sub_bots                 │   │
    │  │ allowed_users            │   │
    │  │ steam_accounts           │   │
    │  │ account_groups           │   │
    │  │ limit_counters           │   │
    │  │ vouchers                 │   │
    │  │ ... (34+ tables)         │   │
    │  └──────────────────────────┘   │
    └──────────────────────────────────┘
```

---

## 🌐 Webhook Flow - تدفق استقبال التحديثات

### مسار Webhook للبوت المركزي:
```
https://fairouz.shop/control_bot.php
```

### مسار Webhook للبوتات الفرعية:
```
https://fairouz.shop/sub_bot.php?bot={BOT_TOKEN}
```

### آلية العمل:

1. **تيليجرام يرسل تحديث** (Update) عبر POST request
2. **PHP يستقبل التحديث** من `php://input`
3. **فك التشفير** من JSON إلى Array
4. **استخراج البيانات**:
   - `message` أو `edited_message` أو `callback_query`
   - `user_id`, `chat_id`, `text`
5. **التحقق من الصلاحيات**:
   - بوت التحكم: المالك فقط (`OWNER_USER_ID`)
   - البوتات الفرعية: مستخدمون مسجلون في `allowed_users`
6. **معالجة الطلب** حسب نوعه
7. **الرد عبر Telegram API**

### حماية من التكرار:
- يتم حفظ `update_id` في ملف مؤقت لمنع المعالجة المكررة (control_bot.php)
- الملفات الأقدم من ساعة يتم حذفها تلقائياً

---

## 🔀 التفريق بين بوت التحكم والبوتات الفرعية

### بوت التحكم (Control Bot)

**الوظيفة**: واجهة إدارة شاملة للمالك

**الملف**: `control_bot.php`

**التوكن**: محفوظ في `.env.php` → `CONTROL_BOT_TOKEN`

**من يستطيع استخدامه**:
- المالك فقط (`OWNER_USER_ID`)
- لا يوجد مدراء فرعيين له

**الأوامر المتاحة**:
- إدارة البوتات: `/addbot`, `/list`, `/pause`, `/deletebot`
- إدارة المستخدمين: `/users`, `/allusers`, `/ban`, `/checkuser`
- إدارة الحسابات: `/accounts`, `/addaccount`, `/deleteaccount`
- المجموعات: `/group_add`, `/group_bind`, `/groups_list`
- الحدود: `/set_daily_all`, `/limit_mode`, `/override_account`
- القسائم: `/generate_voucher`, `/redeem`, `/vouchers`
- البث: `/broadcast`, `/broadcast_all`
- الصيانة: `/status`, `/cleanup_logs`

**لا يقدم خدمة أكواد Steam Guard** - فقط إدارة

---

### البوتات الفرعية (Sub Bots)

**الوظيفة**: تقديم خدمة أكواد Steam Guard للمستخدمين

**الملف**: `sub_bot.php`

**التوكن**: محفوظ في قاعدة البيانات → جدول `sub_bots`

**من يستطيع استخدامه**:
1. المستخدمون المسجلون في `allowed_users`
2. المدراء الفرعيون في `bot_managers`

**الأوامر للمستخدمين العاديين**:
- `/start` - رسالة الترحيب
- `اسم_الحساب` - الحصول على كود Steam Guard

**الأوامر للمدراء الفرعيين**:
- `/admin` - عرض القائمة
- `/users`, `/search`, `/ban`, `/unban`, `/top_users`
- `/broadcast`, `/broadcast_log`
- `/redeem`, `/vouchers_log`
- `/mystats`, `/userstats`, `/codes_today`, `/quota`

**الصلاحيات** (يحددها المالك):
1. بث (Broadcast)
2. حظر (Ban)
3. تعبئة قسائم (Voucher Redeem)
4. عرض المستخدمين (View Users)
5. البحث عن مستخدم (Search)
6. تعديل حدود المستخدم (Modify Limits)

---

## ⚙️ مسار تنفيذ الأوامر (Command Handling Flow)

### في بوت التحكم (`control_bot.php`)

```
1. استقبال Update من Telegram
   ↓
2. التحقق من المالك (OWNER_USER_ID)
   ↓ (إذا لم يكن المالك → رفض)
   ↓
3. فحص Session نشط؟ (مثل await_welcome)
   ↓ (نعم → معالجة خاصة)
   ↓ (لا)
   ↓
4. فحص Callback Query؟ (أزرار inline)
   ↓ (نعم → معالجة help sections)
   ↓ (لا)
   ↓
5. تحليل الأمر (/)
   ↓
6. Switch Statement ضخم (~150+ حالة)
   ↓
7. تنفيذ الأمر (قراءة/كتابة DB)
   ↓
8. إرسال الرد عبر tg_send()
```

### في البوتات الفرعية (`sub_bot.php`)

```
1. استقبال Update من Telegram
   ↓
2. جلب إعدادات البوت من sub_bots
   ↓
3. فحص: هل البوت موقوف؟ (is_paused)
   ↓ (نعم → إرسال رسالة توقف)
   ↓ (لا)
   ↓
4. فحص: هل المستخدم مسموح؟ (allowed_users)
   ↓ (لا)
   │   ↓
   │   4a. فحص: وصلنا للحد الأقصى؟ (max_users)
   │   4b. فحص: مشترك في القناة؟ (channel_id)
   │   4c. إضافة المستخدم
   ↓ (نعم)
   ↓
5. فحص: أمر مدير فرعي؟ (/)
   ↓ (نعم)
   │   ↓
   │   5a. التحقق من الصلاحيات
   │   5b. تنفيذ الأمر
   ↓ (لا → نعامله كاسم حساب)
   ↓
6. البحث عن الحساب في:
   - steam_accounts (active)
   - group_accounts (ربط المجموعات)
   - bot_groups (بوتات المجموعة)
   ↓ (لم يُعثر عليه → رسالة خطأ)
   ↓
7. نظام الحدود الذكي (check_and_consume_limit)
   ↓ (مرفوض → إرسال رسالة حد)
   ↓ (مقبول)
   ↓
8. توليد كود Steam Guard
   ↓
9. تسجيل في steam_requests
   ↓
10. إرسال الكود + تنبيه (إن وُجد)
```

---

## 🔑 نقاط قوة البنية

1. **فصل واضح**: بوت التحكم منفصل عن البوتات الفرعية
2. **قابلية التوسع**: إضافة عدد غير محدود من البوتات
3. **نظام صلاحيات متقدم**: للمدراء الفرعيين
4. **نظام حدود ذكي**: 3 أوضاع (يومي/أسبوعي/شهري)
5. **نظام مجموعات**: لتنظيم الحسابات حسب البوتات
6. **Webhook**: استجابة فورية بدون Polling

---

## ⚠️ نقاط ضعف محتملة

1. **عدم وجود Pagination**: قد تفشل `/list` و `/allusers` مع بيانات كبيرة
2. **لا يوجد Queue للبث**: قد يؤدي لـ Rate Limiting في Telegram
3. **Switch Statement ضخم**: في control_bot (~1500+ سطر)
4. **عدم وجود Transaction**: في بعض العمليات الحرجة
5. **تسجيل الأخطاء محدود**: لا يوجد نظام Logging شامل

---

## 📊 إحصائيات الكود

- **إجمالي الملفات الرئيسية**: 7 ملفات
- **إجمالي أسطر PHP**: ~4,750 سطر
- **إجمالي الجداول في DB**: 34+ جدول
- **إجمالي الأوامر (تقريبي)**: 100+ أمر
- **عدد Views في DB**: 2 (active_bans, current_usage)
- **عدد Stored Procedures**: 2 (cleanup, reset)

---

## 🔄 دورة حياة طلب Code

```
المستخدم يرسل "acc1" في البوت الفرعي
    ↓
sub_bot.php يستقبل Update
    ↓
التحقق من allowed_users (مسموح؟)
    ↓
البحث عن acc1 في:
  - steam_accounts (نشط؟)
  - عضو في مجموعة البوت؟
    ↓
check_and_consume_limit():
  1. فحص الحظر (limit_bans)
  2. جلب الحدود (global/bot/override)
  3. جلب العدادات (limit_counters)
  4. فحص الحد اليومي
  5. فحص الحد الأسبوعي/الشهري
  6. زيادة العداد
    ↓ (مسموح)
    ↓
steam_guard_code(shared_secret)
  - توليد TOTP code (5 أحرف)
    ↓
تسجيل في steam_requests
    ↓
إرسال الكود للمستخدم
```

---

## 📝 ملاحظات تقنية

### 1. استخدام PDO
- جميع الاستعلامات تستخدم **Prepared Statements**
- حماية ضد SQL Injection

### 2. Strict Types
- `declare(strict_types=1);` في جميع الملفات

### 3. Error Handling
- استخدام `try-catch` في معظم العمليات
- تسجيل الأخطاء عبر `error_log()`

### 4. Rate Limiting
- تأخير 50-200ms بين الرسائل في البث
- لمنع حظر Telegram

---

## 🎯 الخلاصة

النظام مصمم بشكل جيد مع فصل واضح بين المسؤوليات. البنية قابلة للتوسع لكن تحتاج لبعض التحسينات في معالجة الرسائل الطويلة ونظام البث.
