# تقرير المشاكل المعروفة (Known Issues & Bugs)

## 📋 نظرة عامة

هذا التقرير يجمع جميع المشاكل والأخطاء المكتشفة في النظام الحالي من خلال تحليل الكود.

---

## 1️⃣ مشكلة طول الرسالة في `/list`

### الوصف

عرض جميع البوتات في رسالة واحدة قد يتجاوز حد تيليجرام (4096 حرف).

### الموقع

`control_bot.php` السطر 176-188

### الكود الحالي

```php
case '/list': {
    $bots = $db->query("SELECT b.*, (SELECT COUNT(*) ...) FROM sub_bots b ...")->fetchAll();
    $out = "📋 قائمة البوتات:\n";
    foreach ($bots as $b) {
        $out .= "• <b>{$b['label']}</b> — {$status}\n";
        $out .= "  قناة: ... | مستخدمون: ...\n";
        $out .= "  الحد الأقصى: ... | token: ...\n\n";
    }
    tg_send($CONTROL_TOKEN, $chat_id, $out);
}
```

### المشكلة

- إذا كان هناك 50+ بوت، سيتجاوز 4096 حرف
- `tg_send()` سيفشل → المالك لن يرى شيئاً

### السبب

عدم وجود نظام تقسيم (Pagination) أو تجزئة الرسائل

### الحل المقترح

**الخيار 1: Pagination**
```php
/list [page]
```

**الخيار 2: تقسيم تلقائي**
```php
$chunks = str_split($out, 3500);
foreach ($chunks as $chunk) {
    tg_send($CONTROL_TOKEN, $chat_id, $chunk);
    usleep(200000);
}
```

---

## 2️⃣ مشكلة طول الرسالة في `/allusers`

### الوصف

عرض جميع المستخدمين (500+) في رسالة واحدة يتجاوز الحد.

### الموقع

`control_bot.php` السطر 285-290

### الكود الحالي

```php
case '/allusers': {
    $rows = $db->query("SELECT DISTINCT user_id FROM allowed_users ORDER BY user_id DESC LIMIT 500")->fetchAll();
    $count = count($rows);
    $list = implode(", ", array_map(fn($r)=>$r['user_id'], $rows));
    tg_send($CONTROL_TOKEN, $chat_id, "👥 إجمالي المستخدمين: <b>{$count}</b>\n{$list}");
}
```

### المشكلة

- 500 معرف × 10 أحرف = 5000 حرف تقريباً
- تجاوز الحد المسموح

### الحل المقترح

**الخيار 1: عرض العدد فقط**
```php
tg_send($CONTROL_TOKEN, $chat_id, "👥 إجمالي المستخدمين: <b>{$count}</b>\n\n💡 استخدم /checkuser للبحث");
```

**الخيار 2: تقسيم**
```php
$chunks = array_chunk($rows, 50);
foreach ($chunks as $i => $chunk) {
    $list = implode(", ", array_map(fn($r)=>$r['user_id'], $chunk));
    tg_send($CONTROL_TOKEN, $chat_id, "صفحة " . ($i+1) . ":\n{$list}");
}
```

---

## 3️⃣ مشكلة التكرار في `/broadcast` (بوت التحكم)

### الوصف

إذا كان نفس المستخدم مسجل أكثر من مرة في `allowed_users` (خطأ في الإدراج)، سيتلقى الرسالة أكثر من مرة.

### الموقع

`control_bot.php` السطر 699

### الكود الحالي

```php
$stmt = $db->prepare("SELECT user_id FROM allowed_users WHERE bot_token=? AND banned=0");
```

### المشكلة

لا يستخدم `DISTINCT`

### الحل المقترح

```php
$stmt = $db->prepare("SELECT DISTINCT user_id FROM allowed_users WHERE bot_token=? AND banned=0");
```

---

## 4️⃣ مشكلة التكرار في `/broadcast_all`

### الوصف

المستخدم المسجل في أكثر من بوت يتلقى الرسالة أكثر من مرة.

### الموقع

`control_bot.php` السطر 712-729

### الكود الحالي

```php
foreach ($bots as $b) {
    $stmt = $db->prepare("SELECT user_id FROM allowed_users WHERE bot_token=? AND banned=0");
    $stmt->execute([$b['bot_token']]);
    $users = $stmt->fetchAll();
    foreach ($users as $u) {
        // إرسال
    }
}
```

### المشكلة

- إذا كان user123 في bot1 و bot2
- سيتلقى الرسالة مرتين

### الحل المقترح

```php
// جلب جميع المستخدمين الفريدين مرة واحدة
$stmt = $db->query("SELECT DISTINCT user_id FROM allowed_users WHERE banned=0");
$users = $stmt->fetchAll();
foreach ($users as $u) {
    tg_call($CONTROL_TOKEN, 'sendMessage', [...]); // استخدام بوت مركزي
}
```

---

## 5️⃣ عدم التحقق من `target_label` في القسائم

### الوصف

يمكن إنشاء قسيمة لبوت غير موجود بدون تحذير.

### الموقع

`control_bot.php` السطر 877-948

### الكود الحالي

```php
$target_label = ($target === 'all') ? null : $target;
// لا يوجد تحقق من وجود البوت
$stmt = $db->prepare("INSERT INTO vouchers(...) VALUES(...)");
```

### المشكلة

```bash
/generate_voucher users 100 nonexistent_bot
```
- تُنشأ القسيمة بنجاح
- لكن لا يمكن تفعيلها لاحقاً

### الحل المقترح

```php
if ($target !== 'all') {
    $check = $db->prepare("SELECT id FROM sub_bots WHERE label=?");
    $check->execute([$target]);
    if (!$check->fetch()) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ البوت <b>{$target}</b> غير موجود");
        break;
    }
}
```

---

## 6️⃣ نوع `days` في القسائم غير مفعّل

### الوصف

يمكن إنشاء قسيمة `days` لكن لا يمكن تفعيلها.

### الموقع

`control_bot.php` السطر 989-994

### الكود الحالي

```php
if ($voucher['voucher_type'] === 'users') {
    // تطبيق
} else {
    tg_send($CONTROL_TOKEN, $chat_id, "⚠️ نوع 'days' غير مدعوم حالياً");
    break;
}
```

### المشكلة

- يمكن إنشاء القسيمة
- لا يمكن استخدامها

### الحل المقترح

**الخيار 1**: إزالة `days` من القائمة
```php
if (!in_array($type, ['users'])) {
```

**الخيار 2**: تطبيق الوظيفة
```php
if ($voucher['voucher_type'] === 'days') {
    // إضافة أيام premium
}
```

---

## 7️⃣ عدم وجود `/groups_list`

### الوصف

لا يوجد أمر لعرض جميع المجموعات دفعة واحدة.

### الموقع

غير موجود في `control_bot.php`

### المشكلة

- المالك يحتاج لاستخدام `/group_info` لكل مجموعة على حدة
- لا يوجد نظرة شاملة

### الحل المقترح

إضافة الأمر `/groups_list`:
```php
case '/groups_list': {
    $groups = $db->query("SELECT * FROM account_groups")->fetchAll();
    $out = "📂 المجموعات:\n\n";
    foreach ($groups as $g) {
        $out .= "• {$g['group_name']}\n";
    }
    tg_send($CONTROL_TOKEN, $chat_id, $out);
}
```

---

## 8️⃣ رسالة خطأ عامة في البوتات الفرعية

### الوصف

عند عدم العثور على الحساب، الرسالة لا تميز بين:
- حساب غير موجود أصلاً
- حساب موجود لكن خارج مجموعات البوت
- حساب معطّل

### الموقع

`sub_bot.php` السطر 664-667

### الكود الحالي

```php
if (!$account) {
    tg_send($token, $chat_id, "❌ اسم الحساب غير صحيح أو غير مفعل.");
    exit;
}
```

### المشكلة

- المستخدم لا يعرف السبب الحقيقي
- صعوبة التشخيص

### الحل المقترح

**ملاحظة**: هذا **مقصود لأسباب أمنية** (لعدم كشف معلومات النظام)

**إذا أُريد التوضيح** (غير منصوح):
```php
// فحص الوجود
$exists = $db->prepare("SELECT id FROM steam_accounts WHERE account_name=?");
$exists->execute([$text]);
if (!$exists->fetch()) {
    tg_send($token, $chat_id, "❌ الحساب غير موجود");
} else {
    tg_send($token, $chat_id, "❌ الحساب غير متاح في هذا البوت");
}
```

---

## 9️⃣ عدم وجود Transaction في العمليات الحرجة

### الوصف

بعض العمليات تُنفذ بدون Transaction، مما قد يؤدي لحالة غير متسقة.

### الموقع

مثال: تفعيل قسيمة

### الكود الحالي

```php
// تطبيق القسيمة
$db->prepare("UPDATE sub_bots SET max_users = max_users + ? WHERE label=?")->execute([...]);

// زيادة العداد
$db->prepare("UPDATE vouchers SET current_uses = current_uses + 1 WHERE code=?")->execute([...]);

// تسجيل
$db->prepare("INSERT INTO voucher_redemptions(...) VALUES(...)")->execute([...]);
```

### المشكلة

- إذا فشلت إحدى العمليات بعد نجاح الأخرى
- سينتج حالة غير متسقة

### الحل المقترح

```php
try {
    $db->beginTransaction();
    
    // تطبيق القسيمة
    $db->prepare("UPDATE sub_bots ...")->execute([...]);
    
    // زيادة العداد
    $db->prepare("UPDATE vouchers ...")->execute([...]);
    
    // تسجيل
    $db->prepare("INSERT INTO voucher_redemptions ...")->execute([...]);
    
    $db->commit();
} catch (Exception $e) {
    $db->rollBack();
    throw $e;
}
```

---

## 🔟 عدم وجود Rate Limiting للأوامر

### الوصف

المالك أو المدراء يمكنهم إرسال أوامر متكررة بسرعة كبيرة.

### الموقع

جميع الأوامر

### المشكلة

- `/broadcast` يمكن تكراره أثناء تنفيذ السابق
- قد يؤدي لتكرار الرسائل

### الحل المقترح

**نظام Anti-Flood للأوامر الحساسة**:
```php
$last_broadcast = $db->prepare("SELECT created_at FROM broadcast_log WHERE manager_id=? ORDER BY id DESC LIMIT 1");
$last_broadcast->execute([$user_id]);
$last = $last_broadcast->fetch();

if ($last && (time() - strtotime($last['created_at'])) < 60) {
    tg_send($token, $chat_id, "⏳ انتظر 60 ثانية قبل البث مرة أخرى");
    exit;
}
```

---

## 1️⃣1️⃣ استعلام معقد في البوتات الفرعية

### الوصف

الاستعلام للحصول على الحسابات يربط 4 جداول، قد يكون بطيئاً.

### الموقع

`sub_bot.php` السطر 649-661

### الكود الحالي

```php
SELECT a.* 
FROM steam_accounts a
JOIN group_accounts ga ON ga.account_id = a.id
JOIN bot_groups bg ON bg.group_id = ga.group_id
JOIN account_groups g ON g.id = ga.group_id
WHERE bg.bot_id = ? AND a.account_name = ? AND a.active = 1 AND g.active = 1
```

### المشكلة

- 4 JOINs قد تكون بطيئة مع بيانات كبيرة
- لا توجد Indexes محسّنة

### الحل المقترح

**إضافة Indexes**:
```sql
CREATE INDEX idx_ga_group ON group_accounts(group_id);
CREATE INDEX idx_ga_account ON group_accounts(account_id);
CREATE INDEX idx_bg_bot ON bot_groups(bot_id);
CREATE INDEX idx_bg_group ON bot_groups(group_id);
```

---

## 1️⃣2️⃣ عدم تسجيل البث في بوت التحكم

### الوصف

`/broadcast` من بوت التحكم لا يُسجل في `broadcast_log`.

### الموقع

`control_bot.php` السطر 690-709

### المشكلة

- لا يوجد سجل تاريخي
- صعوبة تتبع من قام بالبث ومتى

### الحل المقترح

إضافة تسجيل بعد البث:
```php
$db->prepare("INSERT INTO broadcast_log(bot_token, manager_id, message_text, recipients_count) VALUES(?,?,?,?)")
    ->execute([$tok, $OWNER, substr($payload, 0, 500), $sent]);
```

---

## 📊 ملخص المشاكل

| # | المشكلة | الخطورة | الأولوية |
|---|---------|---------|----------|
| 1 | طول رسالة `/list` | 🔴 عالية | 1 |
| 2 | طول رسالة `/allusers` | 🔴 عالية | 1 |
| 3 | تكرار `/broadcast` (بوت تحكم) | 🟡 متوسطة | 2 |
| 4 | تكرار `/broadcast_all` | 🟡 متوسطة | 2 |
| 5 | عدم التحقق من `target_label` | 🟢 منخفضة | 3 |
| 6 | نوع `days` غير مفعّل | 🟢 منخفضة | 3 |
| 7 | عدم وجود `/groups_list` | 🟢 منخفضة | 4 |
| 8 | رسالة خطأ عامة | 🟢 منخفضة | 5 |
| 9 | عدم وجود Transaction | 🟡 متوسطة | 2 |
| 10 | عدم وجود Rate Limiting | 🟡 متوسطة | 3 |
| 11 | استعلام معقد | 🟡 متوسطة | 3 |
| 12 | عدم تسجيل البث | 🟢 منخفضة | 4 |

---

## 🎯 الخلاصة

معظم المشاكل **غير حرجة** ويمكن التعايش معها. الأولوية العليا لمعالجة:
1. **تقسيم الرسائل الطويلة** (`/list`, `/allusers`)
2. **إضافة DISTINCT** في البث
3. **استخدام Transactions** في العمليات الحرجة
