# تقرير نظام الحدود (Limits System)

## 📋 نظرة عامة

نظام الحدود الذكي (Smart Limit System) يتحكم في **عدد الأكواد المسموح بها** لكل مستخدم.

**الأوضاع المتاحة**:
- `daily`: حد يومي فقط
- `weekly`: حد يومي + أسبوعي (مع حظر)
- `monthly`: حد يومي + شهري (مع حظر)

**الملفات الرئيسية**:
- `lib/limits_core.php` - الدالة الرئيسية
- `lib/limits.php` - الدوال المساعدة

---

## 🗂️ الجداول المستخدمة

### 1. `limits_global` - الحدود العامة (الأولوية 3)
### 2. `limits_bot` - حدود البوت (الأولوية 2)
### 3. `limits_override` - تجاوز للحسابات (الأولوية 1)
### 4. `limit_counters` - العدادات
### 5. `limit_bans` - الحظر المؤقت
### 6. `limit_messages` - رسائل الأحداث

---

## 🎯 ترتيب الأولويات

```
1️⃣ limits_override (لحساب معين)
     ↓ (إذا لم يوجد)
2️⃣ limits_bot (لبوت معين)
     ↓ (إذا لم يوجد)
3️⃣ limits_global (للجميع)
     ↓ (إذا لم يوجد)
افتراضي: daily, 2 per_day
```

---

## ⚙️ الدالة الرئيسية

**الاسم**: `check_and_consume_limit()`

**الملف**: `lib/limits_core.php` السطر 21

**المعاملات**:
- `$db` - اتصال قاعدة البيانات
- `$bot_label` - اسم البوت
- `$user_id` - معرف المستخدم
- `$account_id` - معرف الحساب
- `$account_name` - اسم الحساب

**المُخرج**:
```php
[
    'allowed' => bool,       // مسموح أم لا
    'message' => string,     // رسالة (إذا مرفوض)
    'warning' => string,     // تنبيه (إذا مسموح)
    'event' => string        // نوع الحدث
]
```

---

## 🔄 مسار التنفيذ

```
1. فحص الحظر (limit_bans)
   ↓ محظور? → رفض
   ↓ غير محظور
2. جلب الحدود (override → bot → global)
   ↓
3. جلب/إنشاء العدادات (limit_counters)
   ↓
4. إعادة تعيين العدادات المنتهية
   ↓
5. فحص الحد حسب الوضع:
   - daily: فحص day_used
   - weekly: فحص day_used + week_used
   - monthly: فحص day_used + month_used
   ↓ مرفوض? → رسالة
   ↓ مسموح
6. زيادة العدادات (increment)
   ↓
7. إرجاع النتيجة + تنبيه (اختياري)
```

---

## 📊 الأوضاع بالتفصيل

### 1. الوضع اليومي (Daily)

**المعاملات**:
- `per_day`: عدد الأكواد اليومية

**المنطق**:
```
إذا day_used >= per_day:
  → رفض (on_limit_hit)

إذا day_used >= 80% per_day:
  → مسموح + تنبيه (on_daily_near)

إذا day_used < 80% per_day:
  → مسموح (بدون تنبيه)
```

**مثال**:
- الحد: 5 أكواد يومياً
- المستخدم طلب 3 أكواد → ✅ مسموح
- المستخدم طلب الرابع → ✅ مسموح + ⚠️ "تبقى لك كود واحد"
- المستخدم طلب الخامس → ✅ مسموح
- المستخدم طلب السادس → ❌ مرفوض

---

### 2. الوضع الأسبوعي (Weekly)

**المعاملات**:
- `per_day`: عدد الأكواد اليومية
- `weekly_cap`: الحد الأسبوعي
- `ban_days`: أيام الحظر عند التجاوز

**المنطق**:
```
إذا week_used >= weekly_cap:
  → حظر ban_days أيام (weekly_exceeded)

إذا day_used >= per_day:
  → رفض (on_limit_hit)

إذا week_used == 3:
  → مسموح + تنبيه (on_share_warning)

غير ذلك:
  → مسموح
```

**مثال**:
- حد يومي: 2
- حد أسبوعي: 7
- حظر: 5 أيام
- المستخدم طلب 7 أكواد خلال الأسبوع → ✅ مسموح
- المستخدم طلب الثامن → ❌ حظر 5 أيام

---

### 3. الوضع الشهري (Monthly)

**المعاملات**:
- `per_day`: عدد الأكواد اليومية
- `monthly_cap`: الحد الشهري
- `ban_days`: أيام الحظر عند التجاوز

**المنطق**:
```
إذا month_used >= monthly_cap:
  → حظر ban_days أيام (monthly_exceeded)

إذا day_used >= per_day:
  → رفض (on_limit_hit)

إذا month_used >= 80% monthly_cap:
  → مسموح + تنبيه (on_daily_near)

غير ذلك:
  → مسموح
```

**مثال**:
- حد يومي: 3
- حد شهري: 50
- حظر: 30 يوم
- المستخدم طلب 50 كود خلال الشهر → ✅ مسموح
- المستخدم طلب الـ51 → ❌ حظر 30 يوم

---

## 🎛️ أوامر الإدارة

| الأمر | الوظيفة |
|-------|---------|
| `/set_daily_all <n>` | حد يومي عام (limits_global) |
| `/limit_mode <bot> <mode> <per_day> [cap] [ban]` | حدود بوت معين |
| `/override_account <acc_id> <mode> <per_day> [cap]` | تجاوز لحساب |
| `/remove_override <acc_id>` | إزالة التجاوز |
| `/show_limit <user> <acc>` | عرض الحدود |
| `/reset_counters <user>` | إعادة تعيين العدادات |
| `/ban_user <user> <acc> <days>` | حظر من حساب |
| `/unban_user <user> <acc>` | إلغاء الحظر |

---

## 📝 رسائل الأحداث (limit_messages)

| الحدث | الوصف | المتغيرات |
|-------|-------|----------|
| `on_limit_hit` | تجاوز الحد اليومي | account, day_used, per_day, reset_time |
| `on_banned` | محظور | account, ban_days, banned_until |
| `on_daily_near` | اقتراب من الحد | account, day_used, per_day, remaining, reset_time |
| `on_share_warning` | تنبيه مشاركة حساب | account, weekly_cap |

**مثال رسالة**:
```
❌ لقد استنفذت الحد اليومي للحساب {account}

📊 استخدمت: {day_used}/{per_day}
⏰ إعادة التعيين في: {reset_time}
```

---

## 🔄 إعادة تعيين العدادات

### تلقائياً (Stored Procedure)

**الملف**: `main.sql.sql` - `reset_expired_counters()`

**يُستدعى**: كل 5 دقائق عبر Cron Job

**الوظيفة**:
```sql
-- إعادة تعيين اليومي
UPDATE limit_counters 
SET day_used = 0, day_reset_at = TOMORROW
WHERE day_reset_at < NOW();

-- إعادة تعيين الأسبوعي
UPDATE limit_counters 
SET week_used = 0, week_reset_at = NEXT_MONDAY
WHERE week_reset_at < NOW();

-- إعادة تعيين الشهري
UPDATE limit_counters 
SET month_used = 0, month_reset_at = NEXT_MONTH
WHERE month_reset_at < NOW();
```

---

### يدوياً

**الدالة**: `reset_user_counters()`

**الملف**: `lib/limits.php` السطر 177

**الاستخدام**:
```php
reset_user_counters($db, $user_id);              // كل عدادات المستخدم
reset_user_counters($db, $user_id, $account_id); // حساب معين
reset_user_counters($db, $user_id, $account_id, $bot_label); // حساب+بوت
```

---

## 🚫 نظام الحظر

### الجدول: `limit_bans`

```sql
CREATE TABLE `limit_bans` (
  `user_id` bigint(20),
  `account_id` int(11),
  `bot_label` varchar(64),
  `banned_until` timestamp,
  `reason` varchar(255),
  UNIQUE KEY (`user_id`, `account_id`, `bot_label`)
);
```

### الوظيفة: `apply_ban()`

```php
apply_ban($db, $user_id, $account_id, $bot_label, $days, $reason);
```

**مثال**:
```php
apply_ban($db, 123456789, 5, 'test1', 7, 'weekly_exceeded');
```

**النتيجة**: حظر المستخدم 123456789 من الحساب رقم 5 في بوت test1 لمدة 7 أيام

---

### تنظيف الحظر المنتهي

**Stored Procedure**: `cleanup_expired_bans()`

**يُستدعى**: كل 5 دقائق عبر Cron Job

```sql
DELETE FROM limit_bans WHERE banned_until < NOW();
```

---

## 🎯 استقلالية العدادات

**ملاحظة مهمة**: العدادات **مستقلة لكل بوت**

**جدول `limit_counters`**:
```sql
UNIQUE KEY (user_id, account_id, bot_label)
```

**المعنى**:
- مستخدم 123 في بوت A → عداد منفصل
- نفس المستخدم 123 في بوت B → عداد منفصل
- لا تتداخل العدادات بين البوتات

**مثال**:
```
المستخدم 123 طلب acc1 في bot1 → 2 مرات
نفس المستخدم طلب acc1 في bot2 → 0 مرات (عداد جديد)
```

---

## 💡 نقاط القوة

1. ✅ **3 أوضاع مرنة** (يومي/أسبوعي/شهري)
2. ✅ **3 مستويات أولوية** (عام/بوت/حساب)
3. ✅ **استقلالية كاملة بين البوتات**
4. ✅ **إعادة تعيين تلقائية**
5. ✅ **حظر مؤقت ذكي**
6. ✅ **تنبيهات مسبقة**
7. ✅ **رسائل قابلة للتخصيص**

---

## ⚠️ نقاط الضعف

1. **الاستعلامات معقدة** - 3 مستويات أولوية
2. **لا يوجد Cache** - كل طلب يستعلم DB
3. **الرسائل في DB** - قد تكون أفضل في الكود
4. **لا يوجد UI** - صعب على المستخدم العادي فهم الحدود

---

## 🎯 الخلاصة

نظام حدود متقدم ومرن يغطي معظم حالات الاستخدام. التصميم احترافي مع استقلالية كاملة بين البوتات.
