-- تحديث نظام المساعدة لتضمين جميع الأوامر الجديدة
-- نفّذ هذا الملف بعد إضافة جميع الأوامر الجديدة

-- ============================================
-- تحديث قوالب المساعدة الرئيسية
-- ============================================

-- قسم البوتات (محدّث)
UPDATE message_templates 
SET text = '🤖 <b>إدارة البوتات:</b>

<b>الأوامر الأساسية:</b>
• /addbot - إضافة بوت جديد
• /list - عرض جميع البوتات
• /pause <label> - إيقاف مؤقت
• /resume <label> - استئناف العمل
• /deletebot <label> - حذف بوت
• /refreshbot <label> - تحديث التوكن

<b>الإعدادات:</b>
• /setmax <label> <count> - تعيين الحد الأقصى للمستخدمين
• /setchannel <label> <id> - تعيين قناة الاشتراك
• /setwelcome <label> - تعيين رسالة الترحيب
• /show_welcome_messages - عرض جميع رسائل الترحيب 🆕

<b>Webhook:</b>
• /webhook_create <bot> - إنشاء رابط 🆕
• /webhook_enable <bot> - تفعيل 🆕
• /webhook_reset <bot> - إعادة ضبط 🆕
• /webhook_delete <bot> - حذف 🆕
• /webhook_info <bot> - معلومات 🆕

💡 مثال: <code>/addbot mybot 123456:ABC-DEF</code>'
WHERE `key` = 'help_bots';

-- قسم المستخدمين (محدّث)
UPDATE message_templates 
SET text = '👥 <b>إدارة المستخدمين:</b>

<b>العرض:</b>
• /users <label> - مستخدمو بوت معين
• /allusers - جميع المستخدمين (مقسّم) ✨
• /users_count - عدد المستخدمين فقط 🆕
• /checkuser <user_id> - البحث عن مستخدم

<b>الإدارة:</b>
• /ban <user_id> [bot] - حظر
• /unban <user_id> [bot] - إلغاء الحظر
• /adduser <label> <user_id> - إضافة يدوياً
• /kickuser <label> <user_id> - طرد

💡 مثال: <code>/users test1</code>'
WHERE `key` = 'help_users';

-- قسم المجموعات (محدّث)
UPDATE message_templates 
SET text = '📂 <b>إدارة المجموعات:</b>

<b>الأساسيات:</b>
• /group_add <name> - إنشاء مجموعة
• /groups_list - عرض الكل (محسّن) ✨
• /group_info <name> - معلومات تفصيلية
• /group_toggle <name> - تفعيل/تعطيل

<b>الربط الفردي:</b>
• /group_bind <bot> <group> - ربط
• /group_unbind <bot> <group> - فصل

<b>الربط المتعدد:</b> 🆕
• /group_bind_multi <group> <bot1> <bot2> ...
• /group_unbind_multi <group> <bot1> <bot2> ...

<b>الحسابات:</b>
• /group_account_add <group> <acc1> [acc2] ...
• /group_account_remove <group> <acc1> ...

💡 مثال: <code>/group_bind_multi 36k test1 test2 test3</code>'
WHERE `key` = 'help_groups';

-- قسم القسائم (محدّث)
UPDATE message_templates 
SET text = '🎫 <b>نظام القسائم:</b>

<b>الإنشاء:</b> ✨
• /generate_voucher <type> <amount> [target] [uses]
  - النوع: users | days
  - الهدف: all | bot_label | group:name 🆕

<b>التفعيل:</b>
• /redeem <code> [bot] - تفعيل قسيمة

<b>الإدارة:</b>
• /vouchers - آخر 50 قسيمة
• /voucher_search <query> - البحث

<b>أمثلة:</b> 🆕
• <code>/generate_voucher users 100</code> - عام
• <code>/generate_voucher users 50 test1</code> - لبوت
• <code>/generate_voucher users 200 group:36k 5</code> - لمجموعة

💡 القسائم المرتبطة بمجموعة تعمل فقط في البوتات المرتبطة بها!'
WHERE `key` = 'help_vouchers';

-- قسم الحدود (محدّث)
UPDATE message_templates 
SET text = '⚙️ <b>نظام الحدود:</b>

<b>الحدود العامة:</b>
• /set_daily_all <count> - حد يومي عام

<b>حدود البوت:</b>
• /limit_mode <bot> <mode> <daily> [cap] [ban]

<b>حدود الحسابات:</b>
• /override_account <id> <mode> <daily> [cap] [ban]
• /override_clear <id>

<b>حدود المستخدمين:</b> 🆕
• /set_user_limit <user_id> <mode> <daily> [cap] [ban] [bot]
• /clear_user_limit <user_id> [bot]
• /show_user_limit <user_id>

<b>العرض:</b>
• /show_limit global | bot | bot/<label> | <id>

<b>الأوضاع:</b>
• daily - يومي فقط
• weekly - يومي + أسبوعي + حظر
• monthly - يومي + شهري + حظر

<b>الأولويات:</b>
1️⃣ override_account (أعلى)
2️⃣ limits_user 🆕
3️⃣ limits_bot
4️⃣ limits_global (أقل)

💡 مثال: <code>/set_user_limit 123456 weekly 5 20 7</code>'
WHERE `key` = 'help_limits';

-- قسم البث (محدّث)
UPDATE message_templates 
SET text = '📢 <b>نظام البث:</b>

<b>من بوت التحكم:</b>
• /broadcast <bot> <text> - بث لبوت محدد
• /broadcast_all <text> - بث لجميع البوتات

<b>من البوت الفرعي:</b>
• /broadcast <text> - بث (يحتاج صلاحية)

<b>السجل:</b>
• /broadcast_log [bot] - آخر عمليات البث

⚠️ <b>ملاحظات:</b>
• تأخير 50ms بين كل رسالة
• يتم تسجيل جميع عمليات البث
• تم إصلاح مشكلة التكرار اللانهائي ✅

💡 مثال: <code>/broadcast test1 مرحباً بالجميع!</code>'
WHERE `key` = 'help_broadcast';

-- إضافة قسم الإحصاءات (جديد)
INSERT INTO message_templates (`key`, `text`) VALUES 
('help_stats', '📊 <b>الإحصاءات والتقارير:</b> 🆕

<b>الإحصاءات المفصلة:</b>
• /stats_bots - إحصاءات البوتات
• /stats_users - إحصاءات المستخدمين
• /stats_groups - إحصاءات المجموعات
• /stats_vouchers - إحصاءات القسائم
• /stats_broadcast - إحصاءات البث
• /stats_all - ملخص شامل

<b>ما يتم عرضه:</b>
✅ الإجمالي والنشط/المحظور
✅ أفضل 5 (الأكثر نشاطاً/مستخدمين)
✅ إحصاءات الفترة الأخيرة
✅ بيانات في الوقت الفعلي

💡 مثال: <code>/stats_all</code> - نظرة سريعة على كل شيء')
ON DUPLICATE KEY UPDATE text=VALUES(text);

-- إضافة قسم الردود (جديد)
INSERT INTO message_templates (`key`, `text`) VALUES 
('help_responses', '📝 <b>إدارة الردود:</b> 🆕

<b>الأوامر:</b>
• /response_add <key> <text> - إضافة رد جديد
• /response_edit <key> <text> - تعديل رد موجود
• /response_delete <key> - حذف رد
• /response_list - عرض جميع المفاتيح
• /response_view <key> - عرض رد محدد

<b>الاستخدام:</b>
الردود المحفوظة تُستخدم في الرسائل الآلية
مثل رسائل الترحيب، الأخطاء، والتنبيهات

💡 مثال: <code>/response_add welcome مرحباً {username}!</code>')
ON DUPLICATE KEY UPDATE text=VALUES(text);

-- تحديث القائمة الرئيسية
UPDATE message_templates 
SET text = '📚 <b>مركز المساعدة:</b>

اختر القسم المطلوب:

🤖 /help bots - إدارة البوتات
👥 /help users - إدارة المستخدمين
📂 /help groups - إدارة المجموعات
🎫 /help vouchers - نظام القسائم
⚙️ /help limits - نظام الحدود
📢 /help broadcast - نظام البث
📊 /help stats - الإحصاءات 🆕
📝 /help responses - إدارة الردود 🆕

💡 <i>جميع الأوامر محمية ومتاحة للمالك فقط</i>

🆕 = أوامر جديدة
✨ = تحسينات'
WHERE `key` = 'help_main';

-- ============================================
-- إنشاء نسخة احتياطية من القوالب القديمة
-- ============================================

CREATE TABLE IF NOT EXISTS `message_templates_backup` LIKE `message_templates`;

-- نسخ جميع القوالب الحالية للنسخ الاحتياطي
INSERT IGNORE INTO `message_templates_backup` 
SELECT * FROM `message_templates`;

-- ============================================
-- ملاحظات التنفيذ
-- ============================================

-- تم تحديث نظام المساعدة ليشمل:
-- ✅ 27 أمر جديد
-- ✅ تحسينات على الأوامر الموجودة
-- ✅ قسمين جديدين (الإحصاءات والردود)
-- ✅ شرح مفصل لكل قسم
-- ✅ أمثلة عملية

SELECT 'تم تحديث نظام المساعدة بنجاح! ✅' as status;
